/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.cache.OnCallRefreshFileObject;
import org.apache.commons.vfs2.function.VfsConsumer;
import org.apache.commons.vfs2.provider.zip.ZipFileObject;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Jira733TestCase {
    @After
    @Before
    public void reset() throws FileSystemException {
        VFS.reset();
    }

    @Test
    public void testZipParentLayer() throws Exception {
        File file = new File("src/test/resources/test-data/test.zip");
        String nestedPath = "zip:" + file.getAbsolutePath() + "!/read-tests/file1.txt";
        try (FileObject fileObject = VFS.getManager().resolveFile(nestedPath);
             OnCallRefreshFileObject wrappedFileObject = new OnCallRefreshFileObject(fileObject);){
            Assert.assertNotNull((String)"getParentLayer() 1", (Object)wrappedFileObject.getFileSystem().getParentLayer());
            wrappedFileObject.exists();
            wrappedFileObject.getContent();
            Assert.assertNotNull((String)"getParentLayer() 2", (Object)wrappedFileObject.getFileSystem().getParentLayer());
        }
    }

    private void testZipParentLayer(VfsConsumer<FileObject> consumer) throws Exception {
        File file = new File("src/test/resources/test-data/test.zip");
        Assert.assertTrue((boolean)file.exists());
        String nestedPath = "zip:" + file.getAbsolutePath() + "!/read-tests/file1.txt";
        try (FileObject fileObject = VFS.getManager().resolveFile(nestedPath);
             OnCallRefreshFileObject wrappedFileObject = new OnCallRefreshFileObject(fileObject);){
            Assert.assertTrue((boolean)(fileObject instanceof ZipFileObject));
            ZipFileObject zipFileObject = (ZipFileObject)fileObject;
            Assert.assertNotNull((String)"getParentLayer() 1", (Object)wrappedFileObject.getFileSystem().getParentLayer());
            consumer.accept((Object)wrappedFileObject);
            Assert.assertNotNull((String)"getParentLayer() 2", (Object)wrappedFileObject.getFileSystem().getParentLayer());
        }
    }

    @Test
    public void testZipParentLayer_exists() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::exists));
    }

    @Test
    public void testZipParentLayer_exists_getContents() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)fileObject -> {
            fileObject.exists();
            fileObject.getContent();
        }));
    }

    @Test
    public void testZipParentLayer_getChildren() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)fileObject -> fileObject.getParent().getChildren()));
    }

    @Test
    public void testZipParentLayer_getContents() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::getContent));
    }

    @Test
    public void testZipParentLayer_getType() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::getType));
    }

    @Test
    public void testZipParentLayer_isAttached() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isAttached));
    }

    @Test
    public void testZipParentLayer_isContentOpen() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isContentOpen));
    }

    @Test
    public void testZipParentLayer_isExecutable() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isExecutable));
    }

    @Test
    public void testZipParentLayer_isFile() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isFile));
    }

    @Test
    public void testZipParentLayer_isFolder() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isFolder));
    }

    @Test
    public void testZipParentLayer_isHidden() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isHidden));
    }

    @Test
    public void testZipParentLayer_isReadable() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isReadable));
    }

    @Test
    public void testZipParentLayer_isWriteable() throws Exception {
        this.testZipParentLayer((VfsConsumer<FileObject>)((VfsConsumer)FileObject::isWriteable));
    }
}

