/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.junit.Test;

public class UrlStructureTests
extends AbstractProviderTestCase {
    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.GET_TYPE, Capability.URI};
    }

    @Test
    public void testFolderURL() throws Exception {
        FileObject folder = this.getReadFolder().resolveFile("dir1");
        if (folder.getFileSystem().hasCapability(Capability.DIRECTORY_READ_CONTENT)) {
            return;
        }
        UrlStructureTests.assertTrue((boolean)folder.exists());
        try (InputStream inputStream = folder.getURL().openConnection().getInputStream();){
            UrlStructureTests.fail();
        }
        catch (IOException e) {
            UrlStructureTests.assertSameMessage("vfs.provider/read-not-file.error", folder, (Throwable)e);
        }
    }
}

