/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.nio.file.Paths;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.junit.Assert;
import org.junit.Test;

public class VFSTest {
    @Test
    public void test_close() throws FileSystemException {
        try (StandardFileSystemManager fileSystemManager = new StandardFileSystemManager();){
            VFS.setManager((FileSystemManager)fileSystemManager);
            VFS.setManager(null);
        }
        Assert.assertNotNull((Object)VFS.getManager());
        Assert.assertFalse((boolean)VFS.getManager().resolveFile(Paths.get("DoesNotExist.not", new String[0]).toUri()).exists());
    }

    @Test
    public void test_setManager() throws FileSystemException {
        StandardFileSystemManager fileSystemManager = new StandardFileSystemManager();
        VFS.setManager((FileSystemManager)fileSystemManager);
        Assert.assertEquals((Object)fileSystemManager, (Object)VFS.getManager());
        VFS.setManager(null);
        Assert.assertNotNull((Object)VFS.getManager());
        Assert.assertNotEquals((Object)fileSystemManager, (Object)VFS.getManager());
    }

    @Test
    public void testStaticClose() throws FileSystemException {
        FileSystemManager manager = VFS.getManager();
        VFS.close();
        Assert.assertNotEquals((Object)manager, (Object)VFS.getManager());
    }

    @Test
    public void testStaticCloseRepeatable() throws FileSystemException {
        VFS.close();
        VFS.close();
    }
}

