/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.EmptyFileFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EmptyFileFilterTest
extends BaseFilterTest {
    private static File testDir;
    private static File notEmptyFile;
    private static FileSelectInfo notEmptyFileInfo;
    private static File emptyFile;
    private static FileSelectInfo emptyFileInfo;
    private static File notEmptyDir;
    private static FileSelectInfo notEmptyDirInfo;
    private static File emptyDir;
    private static FileSelectInfo emptyDirInfo;
    private static File notExistingFile;
    private static FileSelectInfo notExistingFileInfo;
    private static File zipFile;
    private static FileObject zipFileObj;

    @AfterClass
    public static void afterClass() throws IOException {
        notEmptyFile = null;
        notEmptyFileInfo = null;
        emptyFile = null;
        emptyFileInfo = null;
        notEmptyDir = null;
        notEmptyDirInfo = null;
        emptyDir = null;
        emptyDirInfo = null;
        notExistingFile = null;
        notExistingFileInfo = null;
        zipFileObj.close();
        FileUtils.deleteQuietly((File)zipFile);
        zipFile = null;
        FileUtils.deleteDirectory((File)testDir);
        testDir = null;
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        testDir = EmptyFileFilterTest.getTestDir(EmptyFileFilterTest.class.getName());
        testDir.mkdir();
        notEmptyFile = new File(testDir, "full.txt");
        FileUtils.write((File)notEmptyFile, (CharSequence)"whatever");
        notEmptyFileInfo = EmptyFileFilterTest.createFileSelectInfo(notEmptyFile);
        emptyFile = new File(testDir, "empty.txt");
        FileUtils.touch((File)emptyFile);
        emptyFileInfo = EmptyFileFilterTest.createFileSelectInfo(emptyFile);
        notEmptyDir = new File(testDir, "full-dir");
        notEmptyDir.mkdir();
        notEmptyDirInfo = EmptyFileFilterTest.createFileSelectInfo(notEmptyDir);
        FileUtils.touch((File)new File(notEmptyDir, "foobar.txt"));
        emptyDir = new File(testDir, "empty-dir");
        emptyDir.mkdir();
        emptyDirInfo = EmptyFileFilterTest.createFileSelectInfo(emptyDir);
        notExistingFile = new File(testDir, "not-existing-file.txt");
        notExistingFileInfo = EmptyFileFilterTest.createFileSelectInfo(notExistingFile);
        zipFile = new File(EmptyFileFilterTest.getTempDir(), EmptyFileFilterTest.class.getName() + ".zip");
        EmptyFileFilterTest.zipDir(testDir, "", zipFile);
        zipFileObj = EmptyFileFilterTest.getZipFileObject(zipFile);
    }

    @Test
    public void testAcceptEmpty() throws FileSystemException {
        FileFilter testee = EmptyFileFilter.EMPTY;
        Assert.assertFalse((boolean)testee.accept(notEmptyFileInfo));
        Assert.assertTrue((boolean)testee.accept(emptyFileInfo));
        Assert.assertFalse((boolean)testee.accept(notEmptyDirInfo));
        Assert.assertTrue((boolean)testee.accept(emptyDirInfo));
        Assert.assertTrue((boolean)testee.accept(notExistingFileInfo));
    }

    @Test
    public void testAcceptNotEmpty() throws FileSystemException {
        FileFilter testee = EmptyFileFilter.NOT_EMPTY;
        Assert.assertTrue((boolean)testee.accept(notEmptyFileInfo));
        Assert.assertFalse((boolean)testee.accept(emptyFileInfo));
        Assert.assertTrue((boolean)testee.accept(notEmptyDirInfo));
        Assert.assertFalse((boolean)testee.accept(emptyDirInfo));
        Assert.assertFalse((boolean)testee.accept(notExistingFileInfo));
    }

    @Test
    public void testZipFile() throws FileSystemException {
        FileObject[] files = zipFileObj.findFiles((FileSelector)new FileFilterSelector(EmptyFileFilter.EMPTY));
        this.assertContains(files, emptyFile.getName());
        Assert.assertEquals((long)1L, (long)files.length);
        files = zipFileObj.findFiles((FileSelector)new FileFilterSelector(EmptyFileFilter.NOT_EMPTY));
        this.assertContains(files, notEmptyFile.getName(), notEmptyDir.getName());
        Assert.assertEquals((long)2L, (long)files.length);
    }
}

