/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileFilterSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.HiddenFileFilter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class HiddenFileFilterTest
extends BaseFilterTest {
    private static File testDir;
    private static File visibleFile;
    private static FileSelectInfo visibleFileInfo;
    private static File hiddenFile;
    private static FileSelectInfo hiddenFileInfo;
    private static File notExistingFile;
    private static FileSelectInfo notExistingFileInfo;
    private static File zipFile;
    private static FileObject zipFileObj;

    @AfterClass
    public static void afterClass() throws IOException {
        visibleFile = null;
        visibleFileInfo = null;
        hiddenFile = null;
        hiddenFileInfo = null;
        notExistingFile = null;
        notExistingFileInfo = null;
        zipFileObj.close();
        FileUtils.deleteQuietly((File)zipFile);
        zipFile = null;
        FileUtils.deleteDirectory((File)testDir);
        testDir = null;
    }

    @BeforeClass
    public static void beforeClass() throws IOException {
        testDir = HiddenFileFilterTest.getTestDir(HiddenFileFilterTest.class.getName());
        testDir.mkdir();
        visibleFile = new File(testDir, "visible.txt");
        FileUtils.touch((File)visibleFile);
        visibleFileInfo = HiddenFileFilterTest.createFileSelectInfo(visibleFile);
        hiddenFile = new File(testDir, "hidden.txt");
        hiddenFileInfo = HiddenFileFilterTest.createFileSelectInfo(hiddenFile);
        notExistingFile = new File(testDir, "not-existing-file.txt");
        notExistingFileInfo = HiddenFileFilterTest.createFileSelectInfo(notExistingFile);
        zipFile = new File(HiddenFileFilterTest.getTempDir(), HiddenFileFilterTest.class.getName() + ".zip");
        HiddenFileFilterTest.zipDir(testDir, "", zipFile);
        zipFileObj = HiddenFileFilterTest.getZipFileObject(zipFile);
    }

    @Test
    public void testAcceptHidden() throws FileSystemException {
        FileFilter testee = HiddenFileFilter.HIDDEN;
        Assert.assertFalse((boolean)testee.accept(visibleFileInfo));
        Assert.assertFalse((boolean)testee.accept(notExistingFileInfo));
    }

    @Test
    public void testAcceptVisible() throws FileSystemException {
        FileFilter testee = HiddenFileFilter.VISIBLE;
        Assert.assertTrue((boolean)testee.accept(visibleFileInfo));
        Assert.assertTrue((boolean)testee.accept(notExistingFileInfo));
    }

    @Test
    public void testZipFile() throws FileSystemException {
        FileObject[] files = zipFileObj.findFiles((FileSelector)new FileFilterSelector(HiddenFileFilter.VISIBLE));
        this.assertContains(files, visibleFile.getName());
        Assert.assertEquals((long)1L, (long)files.length);
    }
}

