/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.vfs2.FileFilter;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.OrFileFilter;
import org.junit.Assert;
import org.junit.Test;

public class OrFileFilterTest
extends BaseFilterTest {
    @Test
    public void testAccept() throws FileSystemException {
        FileSelectInfo any = OrFileFilterTest.createFileSelectInfo(new File("anyfile"));
        Assert.assertFalse((boolean)new OrFileFilter().accept(any));
        Assert.assertTrue((boolean)new OrFileFilter(new FileFilter[]{new True()}).accept(any));
        Assert.assertTrue((boolean)new OrFileFilter(new FileFilter[]{new True(), new True()}).accept(any));
        Assert.assertTrue((boolean)new OrFileFilter(new FileFilter[]{new False(), new True()}).accept(any));
        Assert.assertTrue((boolean)new OrFileFilter(new FileFilter[]{new True(), new False()}).accept(any));
        Assert.assertFalse((boolean)new OrFileFilter(new FileFilter[]{new False()}).accept(any));
        Assert.assertFalse((boolean)new OrFileFilter(new FileFilter[]{new False(), new False()}).accept(any));
    }

    @Test
    public void testAddFileFilter() {
        DummyFilter filter1 = new DummyFilter();
        DummyFilter filter2 = new DummyFilter();
        DummyFilter filter3 = new DummyFilter();
        OrFileFilter testee = new OrFileFilter();
        testee.addFileFilter((FileFilter)filter1);
        testee.addFileFilter((FileFilter)filter2);
        testee.addFileFilter((FileFilter)filter3);
        OrFileFilterTest.assertContainsOnly(testee.getFileFilters(), filter1, filter2, filter3);
    }

    @Test
    public void testOrFileFilterFileFilter() {
        DummyFilter filter1 = new DummyFilter();
        DummyFilter filter2 = new DummyFilter();
        DummyFilter filter3 = new DummyFilter();
        OrFileFilter testee = new OrFileFilter(new FileFilter[]{filter1, filter2, filter3});
        OrFileFilterTest.assertContainsOnly(testee.getFileFilters(), filter1, filter2, filter3);
    }

    @Test
    public void testOrFileFilterList() {
        DummyFilter filter1 = new DummyFilter();
        DummyFilter filter2 = new DummyFilter();
        DummyFilter filter3 = new DummyFilter();
        ArrayList<DummyFilter> list = new ArrayList<DummyFilter>();
        list.add(filter1);
        list.add(filter2);
        list.add(filter3);
        OrFileFilter testee = new OrFileFilter(list);
        OrFileFilterTest.assertContainsOnly(testee.getFileFilters(), filter1, filter2, filter3);
    }

    @Test
    public void testRemoveFileFilter() {
        DummyFilter filter1 = new DummyFilter();
        DummyFilter filter2 = new DummyFilter();
        DummyFilter filter3 = new DummyFilter();
        OrFileFilter testee = new OrFileFilter(new FileFilter[]{filter1, filter2, filter3});
        testee.removeFileFilter((FileFilter)filter2);
        OrFileFilterTest.assertContainsOnly(testee.getFileFilters(), filter1, filter3);
    }

    @Test
    public void testSetFileFilters() {
        DummyFilter filter1 = new DummyFilter();
        DummyFilter filter2 = new DummyFilter();
        DummyFilter filter3 = new DummyFilter();
        ArrayList<DummyFilter> list = new ArrayList<DummyFilter>();
        list.add(filter1);
        list.add(filter2);
        list.add(filter3);
        OrFileFilter testee = new OrFileFilter();
        testee.setFileFilters(list);
        OrFileFilterTest.assertContainsOnly(testee.getFileFilters(), filter1, filter2, filter3);
    }

    private static class True
    implements FileFilter {
        private True() {
        }

        public boolean accept(FileSelectInfo fileInfo) {
            return true;
        }
    }

    private static class False
    implements FileFilter {
        private False() {
        }

        public boolean accept(FileSelectInfo fileInfo) {
            return false;
        }
    }

    private static class DummyFilter
    implements FileFilter {
        private DummyFilter() {
        }

        public boolean accept(FileSelectInfo fileInfo) {
            return false;
        }
    }
}

