/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.filter;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.filter.BaseFilterTest;
import org.apache.commons.vfs2.filter.IOCase;
import org.apache.commons.vfs2.filter.RegexFileFilter;
import org.junit.Assert;
import org.junit.Test;

public class RegexFileFilterTestCase
extends BaseFilterTest {
    @Test
    public void testPatternNullArgConstruction() {
        try {
            new RegexFileFilter((Pattern)null);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Pattern is missing", (Object)ex.getMessage());
        }
    }

    @Test
    public void testRegex() throws Exception {
        RegexFileFilter filter = new RegexFileFilter("^.*[tT]est(-\\d+)?\\.java$");
        Assert.assertTrue((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("Test.java"))));
        Assert.assertTrue((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("test-10.java"))));
        Assert.assertFalse((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("test-.java"))));
        filter = new RegexFileFilter("^[Tt]est.java$");
        Assert.assertTrue((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("Test.java"))));
        Assert.assertTrue((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("test.java"))));
        Assert.assertFalse((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("tEST.java"))));
        filter = new RegexFileFilter(Pattern.compile("^test.java$", 2));
        Assert.assertTrue((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("Test.java"))));
        Assert.assertTrue((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("test.java"))));
        Assert.assertTrue((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("tEST.java"))));
        filter = new RegexFileFilter("^test.java$", 2);
        Assert.assertTrue((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("Test.java"))));
        Assert.assertTrue((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("test.java"))));
        Assert.assertTrue((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("tEST.java"))));
        filter = new RegexFileFilter("^test.java$", IOCase.INSENSITIVE);
        Assert.assertTrue((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("Test.java"))));
        Assert.assertTrue((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("test.java"))));
        Assert.assertTrue((boolean)filter.accept(RegexFileFilterTestCase.createFileSelectInfo(new File("tEST.java"))));
    }

    @Test
    public void testStringIOCaseNullArgConstruction() {
        try {
            new RegexFileFilter((String)null, IOCase.INSENSITIVE);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Pattern is missing", (Object)ex.getMessage());
        }
    }

    @Test
    public void testStringNullArgConstruction() {
        try {
            new RegexFileFilter((String)null);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Pattern is missing", (Object)ex.getMessage());
        }
    }

    @Test
    public void testStringPatternNullArgConstruction() {
        try {
            new RegexFileFilter((String)null, 2);
            Assert.fail();
        }
        catch (IllegalArgumentException ex) {
            Assert.assertEquals((Object)"Pattern is missing", (Object)ex.getMessage());
        }
    }
}

