/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.vfs2.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileChangeEvent;
import org.apache.commons.vfs2.FileListener;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileMonitor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class DefaultFileMonitorTest {
    private static final int DELAY_MILLIS = 100;
    private FileSystemManager fileSystemManager;
    private File testDir;
    private volatile Status status;
    private File testFile;

    private void deleteTestFileIfPresent() {
        if (this.testFile != null && this.testFile.exists()) {
            boolean deleted = this.testFile.delete();
            Assert.assertTrue((String)this.testFile.toString(), (boolean)deleted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="VFS-299")
    @Test
    public void ignore_testAddRemove() throws Exception {
        try (FileObject fileObject = this.fileSystemManager.resolveFile(this.testFile.toURI().toString());){
            CountingListener listener = new CountingListener();
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)listener);
            monitor.setDelay(100L);
            try {
                monitor.addFile(fileObject);
                monitor.removeFile(fileObject);
                monitor.addFile(fileObject);
                monitor.start();
                this.writeToFile(this.testFile);
                Thread.sleep(300L);
                Assert.assertEquals((String)"Created event is only fired once", (long)1L, (long)listener.created.get());
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="VFS-299")
    @Test
    public void ignore_testStartStop() throws Exception {
        try (FileObject fileObject = this.fileSystemManager.resolveFile(this.testFile.toURI().toString());){
            CountingListener stoppedListener = new CountingListener();
            DefaultFileMonitor stoppedMonitor = new DefaultFileMonitor((FileListener)stoppedListener);
            stoppedMonitor.start();
            try {
                stoppedMonitor.addFile(fileObject);
            }
            finally {
                stoppedMonitor.stop();
            }
            CountingListener activeListener = new CountingListener();
            DefaultFileMonitor activeMonitor = new DefaultFileMonitor((FileListener)activeListener);
            activeMonitor.setDelay(100L);
            activeMonitor.addFile(fileObject);
            activeMonitor.start();
            try {
                this.writeToFile(this.testFile);
                Thread.sleep(1000L);
                Assert.assertEquals((String)"The listener of the active monitor received one created event", (long)1L, (long)activeListener.created.get());
                Assert.assertEquals((String)"The listener of the stopped monitor received no events", (long)0L, (long)stoppedListener.created.get());
            }
            finally {
                activeMonitor.stop();
            }
        }
    }

    @Before
    public void setUp() throws Exception {
        this.fileSystemManager = VFS.getManager();
        this.testDir = AbstractVfsTestCase.getTestDirectoryFile();
        this.status = null;
        this.testFile = new File(this.testDir, "testReload.properties");
        this.deleteTestFileIfPresent();
    }

    @After
    public void tearDown() {
        this.deleteTestFileIfPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChildFileDeletedWithoutRecursiveChecking() throws Exception {
        this.writeToFile(this.testFile);
        try (FileObject fileObject = this.fileSystemManager.resolveFile(this.testDir.toURI().toURL().toString());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(2000L);
            monitor.setRecursive(false);
            monitor.addFile(fileObject);
            monitor.start();
            try {
                this.status = null;
                Thread.sleep(500L);
                this.testFile.delete();
                Thread.sleep(3000L);
                Assert.assertEquals((String)"Event should not have occurred", null, (Object)((Object)this.status));
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChildFileRecreated() throws Exception {
        this.writeToFile(this.testFile);
        try (FileObject fileObj = this.fileSystemManager.resolveFile(this.testDir.toURI().toURL().toString());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(2000L);
            monitor.setRecursive(true);
            monitor.addFile(fileObj);
            monitor.start();
            try {
                this.status = null;
                Thread.sleep(500L);
                this.testFile.delete();
                this.waitFor(Status.DELETED, 3000L);
                this.status = null;
                Thread.sleep(500L);
                this.writeToFile(this.testFile);
                this.waitFor(Status.CREATED, 3000L);
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCreated() throws Exception {
        try (FileObject fileObject = this.fileSystemManager.resolveFile(this.testFile.toURI().toURL().toString());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(100L);
            monitor.addFile(fileObject);
            monitor.start();
            try {
                this.writeToFile(this.testFile);
                Thread.sleep(500L);
                this.waitFor(Status.CREATED, 500L);
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileDeleted() throws Exception {
        this.writeToFile(this.testFile);
        try (FileObject fileObject = this.fileSystemManager.resolveFile(this.testFile.toURI().toString());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(100L);
            monitor.addFile(fileObject);
            monitor.start();
            try {
                this.testFile.delete();
                this.waitFor(Status.DELETED, 500L);
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileModified() throws Exception {
        this.writeToFile(this.testFile);
        try (FileObject fileObject = this.fileSystemManager.resolveFile(this.testFile.toURI().toURL().toString());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(100L);
            monitor.addFile(fileObject);
            monitor.start();
            try {
                Thread.sleep(1000L);
                long valueMillis = System.currentTimeMillis();
                boolean rcMillis = this.testFile.setLastModified(valueMillis);
                Assert.assertTrue((String)"setLastModified succeeded", (boolean)rcMillis);
                this.waitFor(Status.CHANGED, 500L);
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileMonitorRestarted() throws Exception {
        try (FileObject fileObject = this.fileSystemManager.resolveFile(this.testFile.toURI().toString());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(100L);
            monitor.addFile(fileObject);
            monitor.start();
            try {
                this.writeToFile(this.testFile);
                Thread.sleep(500L);
            }
            finally {
                monitor.stop();
            }
            monitor.start();
            try {
                this.testFile.delete();
                this.waitFor(Status.DELETED, 500L);
            }
            finally {
                monitor.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileRecreated() throws Exception {
        try (FileObject fileObject = this.fileSystemManager.resolveFile(this.testFile.toURI());){
            DefaultFileMonitor monitor = new DefaultFileMonitor((FileListener)new TestFileListener());
            monitor.setDelay(100L);
            monitor.addFile(fileObject);
            monitor.start();
            try {
                this.writeToFile(this.testFile);
                this.waitFor(Status.CREATED, 1000L);
                this.status = null;
                this.testFile.delete();
                this.waitFor(Status.DELETED, 1000L);
                this.status = null;
                Thread.sleep(500L);
                monitor.addFile(fileObject);
                this.writeToFile(this.testFile);
                this.waitFor(Status.CREATED, 1000L);
            }
            finally {
                monitor.stop();
            }
        }
    }

    private void waitFor(Status expected, long timeoutMillis) throws InterruptedException {
        if (expected == this.status) {
            return;
        }
        long interval = timeoutMillis / 10L;
        for (long remaining = timeoutMillis; remaining > 0L; remaining -= interval) {
            Thread.sleep(interval);
            if (expected != this.status) continue;
            return;
        }
        Assert.assertTrue((String)"No event occurred", (this.status != null ? 1 : 0) != 0);
        Assert.assertEquals((String)("Incorrect event " + (Object)((Object)this.status)), (Object)((Object)expected), (Object)((Object)this.status));
    }

    private void writeToFile(File file) throws IOException {
        try (BufferedWriter out = Files.newBufferedWriter(file.toPath(), new OpenOption[0]);){
            out.write("string=value1");
        }
    }

    private class TestFileListener
    implements FileListener {
        private TestFileListener() {
        }

        public void fileChanged(FileChangeEvent event) throws Exception {
            DefaultFileMonitorTest.this.status = Status.CHANGED;
        }

        public void fileCreated(FileChangeEvent event) throws Exception {
            DefaultFileMonitorTest.this.status = Status.CREATED;
        }

        public void fileDeleted(FileChangeEvent event) throws Exception {
            DefaultFileMonitorTest.this.status = Status.DELETED;
        }
    }

    private static enum Status {
        CHANGED,
        DELETED,
        CREATED;

    }

    private static class CountingListener
    implements FileListener {
        private final AtomicLong created = new AtomicLong();
        private final AtomicLong changed = new AtomicLong();
        private final AtomicLong deleted = new AtomicLong();

        private CountingListener() {
        }

        public void fileChanged(FileChangeEvent event) {
            this.changed.incrementAndGet();
        }

        public void fileCreated(FileChangeEvent event) {
            this.created.incrementAndGet();
        }

        public void fileDeleted(FileChangeEvent event) {
            this.deleted.incrementAndGet();
        }
    }
}

