/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl;

import java.io.File;
import java.nio.file.Paths;
import org.apache.commons.vfs2.CacheStrategy;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.cache.NullFilesCache;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.bzip2.Bzip2FileObject;
import org.apache.commons.vfs2.provider.gzip.GzipFileObject;
import org.apache.commons.vfs2.provider.jar.JarFileObject;
import org.apache.commons.vfs2.provider.ram.RamFileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileObject;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DefaultFileSystemManagerTest {
    @Test
    public void test_close() throws FileSystemException {
        try (DefaultFileSystemManager fileSystemManager = new DefaultFileSystemManager();){
            VFS.setManager((FileSystemManager)fileSystemManager);
            VFS.setManager(null);
        }
        Assert.assertNotNull((Object)VFS.getManager());
        Assert.assertFalse((boolean)VFS.getManager().resolveFile(Paths.get("DoesNotExist.not", new String[0]).toUri()).exists());
    }

    @Test
    public void testAddAndRemoveProvider() throws FileSystemException {
        try (DefaultFileSystemManager fileSystemManager = new DefaultFileSystemManager();){
            fileSystemManager.setFilesCache((FilesCache)new NullFilesCache());
            fileSystemManager.setCacheStrategy(CacheStrategy.MANUAL);
            RamFileProvider provider = (RamFileProvider)Mockito.spy((Object)new RamFileProvider());
            fileSystemManager.addProvider("ram1", (FileProvider)provider);
            fileSystemManager.addProvider("ram2", (FileProvider)provider);
            Assert.assertNotNull((Object)fileSystemManager.resolveFile("ram1:///"));
            Assert.assertNotNull((Object)fileSystemManager.resolveFile("ram2:///"));
            fileSystemManager.removeProvider("ram1");
            ((RamFileProvider)Mockito.verify((Object)provider, (VerificationMode)Mockito.never())).close();
            Assert.assertThrows(FileSystemException.class, () -> fileSystemManager.resolveFile("ram1:///"));
            Assert.assertNotNull((Object)fileSystemManager.resolveFile("ram2:///"));
            fileSystemManager.removeProvider("ram2");
            ((RamFileProvider)Mockito.verify((Object)provider)).close();
            Assert.assertThrows(FileSystemException.class, () -> fileSystemManager.resolveFile("ram2:///"));
        }
    }

    @Test
    public void testCreateBz2FileSystem() throws FileSystemException {
        this.testCreateFileSystem("src/test/resources/test-data/bla.txt.bz2", Bzip2FileObject.class);
    }

    private void testCreateFileSystem(String path, Class<?> clazz) throws FileSystemException {
        FileSystemManager manager = VFS.getManager();
        try (FileObject localFileObject = manager.resolveFile(new File(path).getAbsolutePath());
             FileObject fileObject = manager.createFileSystem(localFileObject);){
            Assert.assertEquals(clazz, fileObject.getClass());
        }
    }

    @Test
    @Ignore
    public void testCreateGzipFileSystem() throws FileSystemException {
        this.testCreateFileSystem("src/test/resources/test-data/\u597d.txt.gz", GzipFileObject.class);
    }

    @Test
    public void testCreateJarFileSystem() throws FileSystemException {
        this.testCreateFileSystem("src/test/resources/test-data/nested.jar", JarFileObject.class);
    }

    @Test
    public void testCreateZipFileSystem() throws FileSystemException {
        this.testCreateFileSystem("src/test/resources/test-data/nested.zip", ZipFileObject.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileCacheEmptyAfterManagerClose() throws FileSystemException {
        FileSystemManager manager = VFS.getManager();
        Assert.assertNotNull((Object)manager);
        try (FileObject fileObject = manager.resolveFile(Paths.get("src/test/resources/test-data/read-tests/file1.txt", new String[0]).toUri());){
            Assert.assertTrue((boolean)fileObject.exists());
            FilesCache filesCache = manager.getFilesCache();
            FileName name = fileObject.getName();
            Assert.assertNotNull((Object)filesCache.getFile(fileObject.getFileSystem(), name));
            manager.close();
            Assert.assertNull((Object)filesCache.getFile(fileObject.getFileSystem(), name));
        }
        finally {
            VFS.close();
        }
    }

    @Test
    public void testFileCacheEmptyAfterVFSClose() throws FileSystemException {
        FileSystemManager manager = VFS.getManager();
        Assert.assertNotNull((Object)manager);
        try (FileObject fileObject = manager.resolveFile(Paths.get("src/test/resources/test-data/read-tests/file1.txt", new String[0]).toUri());){
            Assert.assertTrue((boolean)fileObject.exists());
            FilesCache filesCache = manager.getFilesCache();
            FileName name = fileObject.getName();
            Assert.assertNotNull((Object)filesCache.getFile(fileObject.getFileSystem(), name));
            VFS.close();
            Assert.assertNull((Object)filesCache.getFile(fileObject.getFileSystem(), name));
        }
    }

    @Test(expected=NullPointerException.class)
    public void testResolveFileAbsoluteThrows() throws FileSystemException {
        String absolute = new File("/").getAbsoluteFile().toURI().toString();
        VFS.getManager().resolveFile((File)null, absolute);
    }

    @Test(expected=FileSystemException.class)
    public void testResolveFileNameNull() throws FileSystemException {
        VFS.getManager().resolveName((FileName)null, "../");
    }

    @Test
    public void testResolveFileObjectNullAbsolute() throws FileSystemException {
        String absolute = new File("/").getAbsoluteFile().toURI().toString();
        VFS.getManager().resolveFile((FileObject)null, absolute);
    }

    @Test(expected=FileSystemException.class)
    public void testResolveFileObjectRelativeThrows() throws FileSystemException {
        VFS.getManager().resolveFile((FileObject)null, "relativePath");
    }

    @Test(expected=NullPointerException.class)
    public void testResolveFileRelativeThrows() throws FileSystemException {
        VFS.getManager().resolveFile((File)null, "relativePath");
    }
}

