/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.bzip2;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.vfs2.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.VFS;
import org.junit.Assert;
import org.junit.Test;

public class Bzip2TestCase
extends AbstractVfsTestCase {
    @Test
    public void testBZip2() throws IOException {
        File testResource = Bzip2TestCase.getTestResource("bla.txt.bz2");
        try (FileObject bz2FileObject = VFS.getManager().resolveFile("bz2://" + testResource);){
            Assert.assertTrue((boolean)bz2FileObject.exists());
            Assert.assertTrue((boolean)bz2FileObject.isFolder());
            try (FileObject fileObjectDir = bz2FileObject.resolveFile("bla.txt");){
                Assert.assertTrue((boolean)fileObjectDir.exists());
                Assert.assertTrue((boolean)bz2FileObject.isFolder());
                try (FileObject fileObject = fileObjectDir.resolveFile("bla.txt");){
                    Assert.assertTrue((boolean)fileObject.exists());
                    Assert.assertFalse((boolean)fileObject.isFolder());
                    Assert.assertTrue((boolean)fileObject.isFile());
                    try (FileContent content = fileObject.getContent();){
                        Assert.assertEquals((long)-1L, (long)content.getSize());
                        String string = content.getString(StandardCharsets.UTF_8);
                        Assert.assertEquals((long)26L, (long)string.length());
                        Assert.assertEquals((Object)"Hallo, dies ist ein Test.\n", (Object)string);
                    }
                }
            }
        }
    }
}

