/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.net.URL;
import java.time.Duration;
import junit.framework.Test;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.ProviderTestConfig;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileProvider;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.FtpFileType;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.command.CommandFactory;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.impl.DefaultFtpServer;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.usermanager.PropertiesUserManagerFactory;
import org.apache.ftpserver.usermanager.impl.BaseUser;
import org.junit.Assert;

public class FtpProviderTestCase
extends AbstractProviderTestConfig {
    private static int SocketPort;
    private static String ConnectionUri;
    private static FtpServer Server;
    private static final String TEST_URI = "test.ftp.uri";
    private static final String USER_PROPS_RES = "org.apache.ftpserver/users.properties";
    private final boolean mdtmLastModifiedTime;

    static String getConnectionUri() {
        return ConnectionUri;
    }

    static int getSocketPort() {
        return SocketPort;
    }

    private static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    static void setUpClass(String rootDirectory, FileSystemFactory fileSystemFactory, CommandFactory commandFactory) throws FtpException {
        if (Server != null) {
            return;
        }
        FtpServerFactory serverFactory = new FtpServerFactory();
        PropertiesUserManagerFactory propertiesUserManagerFactory = new PropertiesUserManagerFactory();
        URL userPropsResource = ClassLoader.getSystemClassLoader().getResource(USER_PROPS_RES);
        Assert.assertNotNull((String)USER_PROPS_RES, (Object)userPropsResource);
        propertiesUserManagerFactory.setUrl(userPropsResource);
        UserManager userManager = propertiesUserManagerFactory.createUserManager();
        BaseUser user = (BaseUser)userManager.getUserByName("test");
        user.setHomeDirectory(rootDirectory);
        userManager.save((User)user);
        serverFactory.setUserManager(userManager);
        if (fileSystemFactory != null) {
            serverFactory.setFileSystem(fileSystemFactory);
        }
        if (commandFactory != null) {
            serverFactory.setCommandFactory(commandFactory);
        }
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(0);
        serverFactory.addListener("default", factory.createListener());
        Server = serverFactory.createServer();
        Server.start();
        SocketPort = ((DefaultFtpServer)Server).getListener("default").getPort();
        ConnectionUri = "ftp://test:test@localhost:" + SocketPort;
    }

    public static Test suite() throws Exception {
        return FtpProviderTestCase.suite(new FtpProviderTestCase(), new Class[0]);
    }

    protected static Test suite(final FtpProviderTestCase testCase, final Class<? extends AbstractProviderTestCase> ... testClasses) throws Exception {
        return new ProviderTestSuite((ProviderTestConfig)testCase){

            @Override
            protected void addBaseTests() throws Exception {
                if (testClasses.length == 0) {
                    super.addBaseTests();
                } else {
                    for (Class test : testClasses) {
                        this.addTests(test);
                    }
                }
            }

            @Override
            protected void setUp() throws Exception {
                if (FtpProviderTestCase.getSystemTestUriOverride() == null) {
                    FtpProviderTestCase.setUpClass(testCase.getFtpRootDir(), testCase.getFtpFileSystem(), testCase.getCommandFactory());
                }
                super.setUp();
            }

            @Override
            protected void tearDown() throws Exception {
                try {
                    super.tearDown();
                }
                finally {
                    FtpProviderTestCase.tearDownClass();
                }
            }
        };
    }

    static void tearDownClass() {
        if (Server != null) {
            Server.stop();
            Server = null;
        }
    }

    public FtpProviderTestCase() {
        this(false);
    }

    public FtpProviderTestCase(boolean mdtmLastModifiedTime) {
        this.mdtmLastModifiedTime = mdtmLastModifiedTime;
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = FtpProviderTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = ConnectionUri;
        }
        FileSystemOptions options = new FileSystemOptions();
        FtpFileSystemConfigBuilder builder = FtpFileSystemConfigBuilder.getInstance();
        this.init(builder, options);
        return manager.resolveFile(uri, options);
    }

    protected CommandFactory getCommandFactory() {
        return null;
    }

    protected FileSystemFactory getFtpFileSystem() throws IOException {
        return null;
    }

    protected String getFtpRootDir() {
        return FtpProviderTestCase.getTestDirectory();
    }

    protected boolean getUserDirIsRoot() {
        return false;
    }

    protected void init(FtpFileSystemConfigBuilder builder, FileSystemOptions options) {
        builder.setUserDirIsRoot(options, this.getUserDirIsRoot());
        builder.setPassiveMode(options, true);
        builder.setFileType(options, FtpFileType.BINARY);
        builder.setConnectTimeout(options, Duration.ofSeconds(10L));
        builder.setControlEncoding(options, "UTF-8");
        builder.setControlKeepAliveReplyTimeout(options, Duration.ofSeconds(35L));
        builder.setControlKeepAliveTimeout(options, Duration.ofSeconds(30L));
        builder.setMdtmLastModifiedTime(options, this.mdtmLastModifiedTime);
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("ftp", (FileProvider)new FtpFileProvider());
    }
}

