/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.provider.ftp.FtpProviderTestCase;
import org.apache.ftpserver.filesystem.nativefs.NativeFileSystemFactory;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.User;

public class FtpProviderUserDirTestCase
extends FtpProviderTestCase {
    public static Test suite() throws Exception {
        return FtpProviderUserDirTestCase.suite(new FtpProviderUserDirTestCase(), new Class[0]);
    }

    @Override
    protected FileSystemFactory getFtpFileSystem() throws IOException {
        File testDir = new File(FtpProviderUserDirTestCase.getTestDirectory());
        File rootDir = new File(testDir, "homeDirIsRoot");
        File homesDir = new File(rootDir, "home");
        File initialDir = new File(homesDir, "test");
        FileUtils.deleteDirectory((File)rootDir);
        rootDir.mkdir();
        FileUtils.copyDirectory((File)testDir, (File)initialDir, pathname -> !pathname.getPath().contains(rootDir.getName()));
        return new NativeFileSystemFactory(){

            public FileSystemView createFileSystemView(User user) throws FtpException {
                FileSystemView fsView = super.createFileSystemView(user);
                fsView.changeWorkingDirectory("home/test");
                return fsView;
            }
        };
    }

    @Override
    protected String getFtpRootDir() {
        return new File(FtpProviderUserDirTestCase.getTestDirectory(), "homeDirIsRoot").getPath();
    }

    @Override
    protected boolean getUserDirIsRoot() {
        return true;
    }
}

