/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http;

import java.io.File;
import java.time.Duration;
import junit.framework.Test;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.http.HttpFileProvider;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs2.util.NHttpFileServer;
import org.junit.Assert;

public class HttpProviderTestCase
extends AbstractProviderTestConfig {
    private static final Duration ONE_MINUTE = Duration.ofMinutes(1L);
    private static NHttpFileServer Server;
    private static int SocketPort;
    private static final String TEST_URI = "test.http.uri";
    private static String ConnectionUri;

    private static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    private static void setUpClass() throws Exception {
        Server = NHttpFileServer.start(0, new File(HttpProviderTestCase.getTestDirectory()), 5000L);
        SocketPort = Server.getPort();
        ConnectionUri = "http://localhost:" + SocketPort;
    }

    public static Test suite() throws Exception {
        return new ProviderTestSuite(new HttpProviderTestCase()){

            @Override
            protected void addBaseTests() throws Exception {
                super.addBaseTests();
                this.addTests(HttpProviderTestCase.class);
            }

            @Override
            protected void setUp() throws Exception {
                if (HttpProviderTestCase.getSystemTestUriOverride() == null) {
                    HttpProviderTestCase.setUpClass();
                }
                super.setUp();
            }

            @Override
            protected void tearDown() throws Exception {
                HttpProviderTestCase.tearDownClass();
                super.tearDown();
            }
        };
    }

    private static void tearDownClass() {
        if (Server != null) {
            Server.close();
        }
    }

    private void checkReadTestsFolder(FileObject file) throws FileSystemException {
        Assert.assertNotNull((Object)file.getChildren());
        Assert.assertTrue((file.getChildren().length > 0 ? 1 : 0) != 0);
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = HttpProviderTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = ConnectionUri;
        }
        return manager.resolveFile(uri);
    }

    public void ignoreTestHttp405() throws FileSystemException {
        try (FileObject fileObject = VFS.getManager().resolveFile("http://www.w3schools.com/webservices/tempconvert.asmx?action=WSDL");){
            assert (fileObject.getContent().getSize() > 0L);
            assert (!fileObject.getContent().isEmpty());
        }
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("http", (FileProvider)new HttpFileProvider());
    }

    public void testHttpTimeoutConfig() {
        FileSystemOptions options = new FileSystemOptions();
        HttpFileSystemConfigBuilder builder = HttpFileSystemConfigBuilder.getInstance();
        HttpProviderTestCase.assertEquals((int)0, (int)builder.getConnectionTimeout(options));
        HttpProviderTestCase.assertEquals((long)0L, (long)builder.getConnectionTimeoutDuration(options).toMillis());
        HttpProviderTestCase.assertEquals((int)0, (int)builder.getSoTimeout(options));
        HttpProviderTestCase.assertEquals((String)"Jakarta-Commons-VFS", (String)builder.getUserAgent(options));
        builder.setConnectionTimeout(options, 60000);
        builder.setSoTimeout(options, 60000);
        builder.setUserAgent(options, "foo/bar");
        HttpProviderTestCase.assertEquals((int)60000, (int)builder.getConnectionTimeout(options));
        HttpProviderTestCase.assertEquals((Object)ONE_MINUTE, (Object)builder.getConnectionTimeoutDuration(options));
        HttpProviderTestCase.assertEquals((int)60000, (int)builder.getSoTimeout(options));
        HttpProviderTestCase.assertEquals((String)"foo/bar", (String)builder.getUserAgent(options));
        builder.setConnectionTimeout(options, ONE_MINUTE);
        builder.setSoTimeout(options, ONE_MINUTE);
        HttpProviderTestCase.assertEquals((int)60000, (int)builder.getConnectionTimeout(options));
        HttpProviderTestCase.assertEquals((Object)ONE_MINUTE, (Object)builder.getConnectionTimeoutDuration(options));
        HttpProviderTestCase.assertEquals((int)60000, (int)builder.getSoTimeout(options));
        HttpProviderTestCase.assertEquals((Object)ONE_MINUTE, (Object)builder.getSoTimeoutDuration(options));
        HttpProviderTestCase.assertEquals((String)"foo/bar", (String)builder.getUserAgent(options));
    }

    private void testResloveFolderSlash(String uri, boolean followRedirect) throws FileSystemException {
        VFS.getManager().getFilesCache().close();
        FileSystemOptions opts = new FileSystemOptions();
        HttpFileSystemConfigBuilder.getInstance().setFollowRedirect(opts, followRedirect);
        try (FileObject file = VFS.getManager().resolveFile(uri, opts);){
            this.checkReadTestsFolder(file);
        }
        catch (FileNotFolderException fileNotFolderException) {
            // empty catch block
        }
    }

    public void testResloveFolderSlashNoRedirectOff() throws FileSystemException {
        this.testResloveFolderSlash(ConnectionUri + "/read-tests", false);
    }

    public void testResloveFolderSlashNoRedirectOn() throws FileSystemException {
        this.testResloveFolderSlash(ConnectionUri + "/read-tests", true);
    }

    public void testResloveFolderSlashYesRedirectOff() throws FileSystemException {
        this.testResloveFolderSlash(ConnectionUri + "/read-tests/", false);
    }

    public void testResloveFolderSlashYesRedirectOn() throws FileSystemException {
        this.testResloveFolderSlash(ConnectionUri + "/read-tests/", true);
    }
}

