/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.TestIdentityRepositoryFactory;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.time.Duration;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileProvider;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystem;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.TrustEveryoneUserInfo;
import org.apache.sshd.SshServer;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.Session;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.util.Buffer;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.FileSystemFactory;
import org.apache.sshd.server.FileSystemView;
import org.apache.sshd.server.ForwardingFilter;
import org.apache.sshd.server.SshFile;
import org.apache.sshd.server.auth.UserAuthNone;
import org.apache.sshd.server.command.ScpCommandFactory;
import org.apache.sshd.server.filesystem.NativeSshFile;
import org.apache.sshd.server.keyprovider.PEMGeneratorHostKeyProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.sftp.SftpSubsystem;

abstract class AbstractSftpProviderTestCase
extends AbstractProviderTestConfig {
    private static int SocketPort;
    private static final String DEFAULT_USER = "testtest";
    protected static String ConnectionUri;
    private static SshServer Server;
    private static final String TEST_URI = "test.sftp.uri";
    protected SftpFileSystem fileSystem;

    AbstractSftpProviderTestCase() {
    }

    private static void connect(String name, InputStream in, OutputStream out, ExitCallback callback) {
        Thread thread = new Thread(() -> {
            int code;
            block5: {
                code = 0;
                try {
                    int len;
                    byte[] buffer = new byte[1024];
                    while ((len = in.read(buffer, 0, buffer.length)) != -1) {
                        out.write(buffer, 0, len);
                        out.flush();
                    }
                }
                catch (SshException buffer) {
                }
                catch (IOException ex2) {
                    if (ex2.getMessage().equals("Pipe closed")) break block5;
                    code = -1;
                }
            }
            if (callback != null) {
                callback.onExit(code);
            }
        }, name);
        thread.setDaemon(true);
        thread.start();
    }

    protected static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    private static void setUpClass(boolean isExecChannelClosed) throws IOException {
        if (Server != null) {
            return;
        }
        String tmpDir = System.getProperty("java.io.tmpdir");
        Server = SshServer.setUpDefaultServer();
        Server.setPort(0);
        if (SecurityUtils.isBouncyCastleRegistered()) {
            File keyFile = File.createTempFile("key", ".pem", new File(tmpDir));
            keyFile.deleteOnExit();
            keyFile.delete();
            PEMGeneratorHostKeyProvider keyProvider = new PEMGeneratorHostKeyProvider(keyFile.getAbsolutePath());
            Server.setKeyPairProvider((KeyPairProvider)keyProvider);
        } else {
            Server.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider(tmpDir + "/key.ser"));
        }
        ArrayList<1> list = new ArrayList<1>(1);
        list.add(new NamedFactory<Command>(){

            public Command create() {
                return new MySftpSubsystem();
            }

            public String getName() {
                return "sftp";
            }
        });
        Server.setSubsystemFactories(list);
        Server.setPasswordAuthenticator((username, password, session) -> StringUtils.equals((CharSequence)username, (CharSequence)password));
        Server.setPublickeyAuthenticator((username, key, session) -> true);
        Server.setForwardingFilter(new ForwardingFilter(){

            public boolean canConnect(InetSocketAddress address, ServerSession session) {
                return true;
            }

            public boolean canForwardAgent(ServerSession session) {
                return true;
            }

            public boolean canForwardX11(ServerSession session) {
                return true;
            }

            public boolean canListen(InetSocketAddress address, ServerSession session) {
                return true;
            }
        });
        Server.setCommandFactory((CommandFactory)new ScpCommandFactory((CommandFactory)new TestCommandFactory(isExecChannelClosed)));
        Server.setFileSystemFactory((FileSystemFactory)new TestFileSystemFactory());
        Server.start();
        SocketPort = Server.getPort();
        ConnectionUri = String.format("sftp://%s@localhost:%d", DEFAULT_USER, SocketPort);
        Server.getUserAuthFactories().add(new UserAuthNone.Factory());
    }

    private static void tearDownClass() throws InterruptedException {
        if (Server != null) {
            Server.stop();
            Server = null;
        }
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = AbstractSftpProviderTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = ConnectionUri;
        }
        FileSystemOptions fileSystemOptions = new FileSystemOptions();
        SftpFileSystemConfigBuilder builder = SftpFileSystemConfigBuilder.getInstance();
        builder.setStrictHostKeyChecking(fileSystemOptions, "no");
        builder.setUserInfo(fileSystemOptions, (UserInfo)new TrustEveryoneUserInfo());
        builder.setIdentityRepositoryFactory(fileSystemOptions, (IdentityRepositoryFactory)new TestIdentityRepositoryFactory());
        builder.setConnectTimeout(fileSystemOptions, Duration.ofSeconds(60L));
        builder.setSessionTimeout(fileSystemOptions, Duration.ofSeconds(60L));
        FileObject fileObject = manager.resolveFile(uri, fileSystemOptions);
        this.fileSystem = (SftpFileSystem)fileObject.getFileSystem();
        return fileObject;
    }

    protected abstract boolean isExecChannelClosed();

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("sftp", (FileProvider)new SftpFileProvider());
    }

    static class TestNativeSshFile
    extends NativeSshFile {
        TestNativeSshFile(String fileName, File file, String userName) {
            super(fileName, file, userName);
        }
    }

    static final class TestFileSystemView
    implements FileSystemView {
        private final String homeDirStr;
        private final String userName;

        public TestFileSystemView(String homeDirStr, String userName) {
            this.homeDirStr = new File(homeDirStr).getAbsolutePath();
            this.userName = userName;
        }

        public SshFile getFile(SshFile baseDir, String file) {
            return this.getFile(baseDir.getAbsolutePath(), file);
        }

        public SshFile getFile(String file) {
            return this.getFile(this.homeDirStr, file);
        }

        protected SshFile getFile(String dir, String file) {
            String home = this.removePrefix(NativeSshFile.normalizeSeparateChar((String)this.homeDirStr));
            String userFileName = this.removePrefix(NativeSshFile.normalizeSeparateChar((String)file));
            File sshFile = userFileName.startsWith(home) ? new File(userFileName) : new File(home, userFileName);
            userFileName = this.removePrefix(NativeSshFile.normalizeSeparateChar((String)sshFile.getAbsolutePath()));
            return new TestNativeSshFile(userFileName, sshFile, this.userName);
        }

        private String removePrefix(String s) {
            int index = s.indexOf(47);
            if (index < 1) {
                return s;
            }
            return s.substring(index);
        }
    }

    static final class TestFileSystemFactory
    implements FileSystemFactory {
        TestFileSystemFactory() {
        }

        public FileSystemView createFileSystemView(Session session) throws IOException {
            String userName = session.getUsername();
            if (!AbstractSftpProviderTestCase.DEFAULT_USER.equals(userName)) {
                return null;
            }
            return new TestFileSystemView(AbstractVfsTestCase.getTestDirectory(), userName);
        }
    }

    private static class TestCommandFactory
    extends ScpCommandFactory {
        public static final Pattern NETCAT_COMMAND = Pattern.compile("nc -q 0 localhost (\\d+)");
        private final boolean isExecChannelClosed;

        public TestCommandFactory(boolean isExecChannelClosed) {
            this.isExecChannelClosed = isExecChannelClosed;
        }

        public Command createCommand(final String command) {
            return new Command(){
                public ExitCallback callback;
                public OutputStream out;
                public OutputStream err;
                public InputStream in;

                public void destroy() {
                }

                public void setErrorStream(OutputStream err) {
                    this.err = err;
                }

                public void setExitCallback(ExitCallback callback) {
                    this.callback = callback;
                }

                public void setInputStream(InputStream in) {
                    this.in = in;
                }

                public void setOutputStream(OutputStream out) {
                    this.out = out;
                }

                public void start(Environment env) throws IOException {
                    int code = 0;
                    if (command.equals("id -G") || command.equals("id -u")) {
                        if (isExecChannelClosed) {
                            throw new IOException("TestingExecChannelClosed");
                        }
                        new PrintStream(this.out).println(0);
                    } else {
                        if (NETCAT_COMMAND.matcher(command).matches()) {
                            Matcher matcher = NETCAT_COMMAND.matcher(command);
                            matcher.matches();
                            int port = Integer.parseInt(matcher.group(1));
                            Socket socket = new Socket((String)null, port);
                            if (this.out != null) {
                                AbstractSftpProviderTestCase.connect("from nc", socket.getInputStream(), this.out, null);
                            }
                            if (this.in != null) {
                                AbstractSftpProviderTestCase.connect("to nc", this.in, socket.getOutputStream(), this.callback);
                            }
                            return;
                        }
                        if (this.err != null) {
                            new PrintStream(this.err).format("Unknown command %s%n", command);
                        }
                        code = -1;
                    }
                    if (this.out != null) {
                        this.out.flush();
                    }
                    if (this.err != null) {
                        this.err.flush();
                    }
                    this.callback.onExit(code);
                }
            };
        }
    }

    static class SftpProviderTestSuite
    extends ProviderTestSuite {
        private final boolean isExecChannelClosed;

        public SftpProviderTestSuite(AbstractSftpProviderTestCase providerConfig) throws Exception {
            super(providerConfig);
            this.isExecChannelClosed = providerConfig.isExecChannelClosed();
        }

        @Override
        protected void setUp() throws Exception {
            if (AbstractSftpProviderTestCase.getSystemTestUriOverride() == null) {
                AbstractSftpProviderTestCase.setUpClass(this.isExecChannelClosed);
            }
            super.setUp();
        }

        @Override
        protected void tearDown() throws Exception {
            for (AbstractSession session : Server.getActiveSessions()) {
                session.close(true);
            }
            AbstractSftpProviderTestCase.tearDownClass();
            super.tearDown();
        }
    }

    private static class SftpAttrs {
        int flags;
        private int uid;
        long size;
        private int gid;
        private int atime;
        private int permissions;
        private int mtime;
        private String[] extended;

        private SftpAttrs(Buffer buf) {
            int flags = buf.getInt();
            if ((flags & 1) != 0) {
                this.size = buf.getLong();
            }
            if ((flags & 2) != 0) {
                this.uid = buf.getInt();
                this.gid = buf.getInt();
            }
            if ((flags & 4) != 0) {
                this.permissions = buf.getInt();
            }
            if ((flags & 8) != 0) {
                this.atime = buf.getInt();
            }
            if ((flags & 8) != 0) {
                this.mtime = buf.getInt();
            }
        }
    }

    private static class MySftpSubsystem
    extends SftpSubsystem {
        TreeMap<String, Integer> permissions = new TreeMap();
        private int _version;

        private MySftpSubsystem() {
        }

        protected void process(Buffer buffer) throws IOException {
            int rpos = buffer.rpos();
            int length = buffer.getInt();
            byte type = buffer.getByte();
            int id = buffer.getInt();
            switch (type) {
                case 9: 
                case 10: {
                    String path = buffer.getString();
                    SftpAttrs attrs = new SftpAttrs(buffer);
                    this.permissions.put(path, attrs.permissions);
                    break;
                }
                case 13: {
                    String path = buffer.getString();
                    this.permissions.remove(path);
                    break;
                }
                case 1: {
                    this._version = id;
                }
            }
            buffer.rpos(rpos);
            super.process(buffer);
        }

        protected void writeAttrs(Buffer buffer, SshFile file, int flags) throws IOException {
            if (!file.doesExist()) {
                throw new FileNotFoundException(file.getAbsolutePath());
            }
            int p = 0;
            Integer cached = this.permissions.get(file.getAbsolutePath());
            if (cached != null) {
                p |= cached.intValue();
            } else {
                if (file.isReadable()) {
                    p |= 0x100;
                }
                if (file.isWritable()) {
                    p |= 0x80;
                }
                if (file.isExecutable()) {
                    p |= 0x40;
                }
            }
            if (this._version >= 4) {
                long size = file.getSize();
                long lastModif = file.getLastModified();
                if (file.isFile()) {
                    buffer.putInt(4L);
                    buffer.putByte((byte)1);
                    buffer.putInt((long)p);
                } else if (file.isDirectory()) {
                    buffer.putInt(4L);
                    buffer.putByte((byte)2);
                    buffer.putInt((long)p);
                } else {
                    buffer.putInt(0L);
                    buffer.putByte((byte)5);
                }
            } else {
                if (file.isFile()) {
                    p |= 0x8000;
                }
                if (file.isDirectory()) {
                    p |= 0x4000;
                }
                if (file.isFile()) {
                    buffer.putInt(13L);
                    buffer.putLong(file.getSize());
                    buffer.putInt((long)p);
                    buffer.putInt(file.getLastModified() / 1000L);
                    buffer.putInt(file.getLastModified() / 1000L);
                } else if (file.isDirectory()) {
                    buffer.putInt(12L);
                    buffer.putInt((long)p);
                    buffer.putInt(file.getLastModified() / 1000L);
                    buffer.putInt(file.getLastModified() / 1000L);
                } else {
                    buffer.putInt(0L);
                }
            }
        }
    }
}

