/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import junit.framework.Test;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.tar.TarFileProvider;

public class NestedTgzTestCase
extends AbstractProviderTestConfig {
    public static Test suite() throws Exception {
        return new ProviderTestSuite(new NestedTgzTestCase(), true);
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String tarFilePath = AbstractVfsTestCase.getTestResource("nested.tgz").getAbsolutePath();
        String uri = "tgz:file:" + tarFilePath + "!/test.tgz";
        FileObject tarFile = manager.resolveFile(uri);
        FileObject nestedFS = manager.createFileSystem(tarFile);
        return nestedFS.resolveFile("/");
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("tgz", (FileProvider)new TarFileProvider());
        manager.addExtensionMap("tgz", "tgz");
        manager.addProvider("tar", (FileProvider)new TarFileProvider());
    }
}

