/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.WeakRefFilesCache;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.junit.Assert;
import org.junit.Test;

public class TarFileSystemTestCase {
    @Test
    public void testTarFileUseDefaultFilesCache() throws FileSystemException {
        this.testUseWeakRefFilesCache("tar", "src/test/resources/test-data/test.tar", null);
    }

    @Test
    public void testTarFileUseWeakRefFilesCache() throws FileSystemException {
        this.testUseWeakRefFilesCache("tar", "src/test/resources/test-data/test.tar", (FilesCache)new WeakRefFilesCache());
    }

    @Test
    public void testTbz2FileUseDefautlFilesCache() throws FileSystemException {
        this.testUseWeakRefFilesCache("tbz2", "src/test/resources/test-data/test.tbz2", null);
    }

    @Test
    public void testTbz2FileUseWeakRefFilesCache() throws FileSystemException {
        this.testUseWeakRefFilesCache("tbz2", "src/test/resources/test-data/test.tbz2", (FilesCache)new WeakRefFilesCache());
    }

    @Test
    public void testTgzFileUseDefaultFilesCache() throws FileSystemException {
        this.testUseWeakRefFilesCache("tgz", "src/test/resources/test-data/test.tgz", null);
    }

    @Test
    public void testTgzFileUseWeakRefFilesCache() throws FileSystemException {
        this.testUseWeakRefFilesCache("tgz", "src/test/resources/test-data/test.tgz", (FilesCache)new WeakRefFilesCache());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUseWeakRefFilesCache(String scheme, String filePath, FilesCache filesCache) throws FileSystemException {
        String fileUri = scheme + ":file:" + new File(filePath).getAbsolutePath();
        FileObject fileObject = null;
        try (StandardFileSystemManager manager = new StandardFileSystemManager();){
            if (filesCache != null) {
                manager.setFilesCache(filesCache);
            }
            manager.init();
            for (int cnt = 0; cnt < 100000; ++cnt) {
                try {
                    fileObject = manager.resolveFile(fileUri);
                    Assert.assertTrue((boolean)fileObject.exists());
                    continue;
                }
                finally {
                    if (fileObject != null) {
                        fileObject.close();
                    }
                    fileObject = null;
                }
            }
        }
    }
}

