/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.test;

import java.io.File;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.AbstractVfsTestCase;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.junit.Test;

public class JunctionTests
extends AbstractProviderTestCase {
    private FileObject getBaseDir() throws FileSystemException {
        File file = AbstractVfsTestCase.getTestDirectoryFile();
        JunctionTests.assertTrue((boolean)file.exists());
        return this.getManager().toFileObject(file);
    }

    @Test
    public void testAncestors() throws Exception {
        FileSystem fs = this.getManager().createVirtualFileSystem("vfs://").getFileSystem();
        FileObject baseDir = this.getBaseDir();
        FileObject file = fs.resolveFile("/a/b");
        JunctionTests.assertFalse((boolean)file.exists());
        file = file.getParent();
        JunctionTests.assertFalse((boolean)file.exists());
        file = file.getParent();
        JunctionTests.assertFalse((boolean)file.exists());
        fs.addJunction("/a/b", baseDir);
        file = fs.resolveFile("/a/b");
        JunctionTests.assertTrue((String)"Does not exist", (boolean)file.exists());
        file = file.getParent();
        JunctionTests.assertTrue((String)"Does not exist", (boolean)file.exists());
        file = file.getParent();
        JunctionTests.assertTrue((String)"Does not exist", (boolean)file.exists());
    }

    @Test
    public void testNestedJunction() throws Exception {
        FileSystem fs = this.getManager().createVirtualFileSystem("vfs:").getFileSystem();
        FileObject baseDir = this.getBaseDir();
        fs.addJunction("/a", baseDir);
        try {
            fs.addJunction("/a/b", baseDir);
            JunctionTests.fail();
        }
        catch (Exception e) {
            JunctionTests.assertSameMessage("vfs.impl/nested-junction.error", "vfs:/a/b", (Throwable)e);
        }
        try {
            fs.addJunction("/a", baseDir);
            JunctionTests.fail();
        }
        catch (Exception e) {
            JunctionTests.assertSameMessage("vfs.impl/nested-junction.error", "vfs:/a", (Throwable)e);
        }
    }
}

