/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class FileLockTestCase {
    private FileSystemManager manager;
    private File newZipFile;
    private String zipFileUri;

    private void assertDelete() {
        Assert.assertTrue((String)"Could not delete file", (boolean)this.newZipFile.delete());
    }

    private void readAndAssert(InputStream inputStream) throws IOException {
        String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        Assert.assertNotNull((Object)string);
        Assert.assertEquals((Object)"This is a test file.", (Object)string);
    }

    private void resolveAndOpenCloseContent() throws FileSystemException {
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);){
            zipFileObject.getContent().close();
        }
    }

    private void resolveAndOpenCloseInputStream() throws IOException, FileSystemException {
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);){
            zipFileObject.getContent().getInputStream().close();
        }
    }

    private void resolveAndOpenReadCloseInputStream() throws IOException, FileSystemException {
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);
             InputStream inputStream = zipFileObject.getContent().getInputStream();){
            this.readAndAssert(inputStream);
        }
    }

    @Before
    public void setup() throws IOException {
        File zipFile = new File("src/test/resources/test-data/test.zip");
        this.newZipFile = File.createTempFile(this.getClass().getSimpleName(), ".zip");
        this.newZipFile.deleteOnExit();
        FileUtils.copyFile((File)zipFile, (File)this.newZipFile);
        this.zipFileUri = "zip:file:" + this.newZipFile.getAbsolutePath() + "!/read-tests/file1.txt";
        this.manager = VFS.getManager();
    }

    @Test
    public void testCannotDeleteWhileStreaming() throws Exception {
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);
             InputStream inputStream = zipFileObject.getContent().getInputStream();){
            if (SystemUtils.IS_OS_WINDOWS) {
                Assert.assertFalse((String)"Could not delete file", (boolean)this.newZipFile.delete());
            }
        }
        this.assertDelete();
    }

    @Test
    public void testCannotDeleteWhileStreaming2() throws Exception {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_WINDOWS);
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);
             InputStream inputStream = zipFileObject.getContent().getInputStream();){
            Assert.assertFalse((String)"Could not delete file", (boolean)this.newZipFile.delete());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadClosedFileObject() throws Exception {
        FileObject zipFileObjectRef;
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);){
            zipFileObjectRef = zipFileObject;
            try (InputStream inputStream = zipFileObject.getContent().getInputStream();){
                this.readAndAssert(inputStream);
            }
        }
        try {
            var3_2 = null;
            try (InputStream inputStream = zipFileObjectRef.getContent().getInputStream();){
                this.readAndAssert(inputStream);
            }
            catch (Throwable throwable) {
                var3_2 = throwable;
                throw throwable;
            }
        }
        finally {
            zipFileObjectRef.close();
        }
        this.assertDelete();
    }

    @Test
    public void testResolveAndOpenCloseContent() throws Exception {
        this.resolveAndOpenCloseContent();
        this.assertDelete();
    }

    @Test
    public void testResolveAndOpenCloseContent3() throws Exception {
        this.resolveAndOpenCloseContent();
        this.resolveAndOpenCloseContent();
        this.resolveAndOpenCloseContent();
        this.assertDelete();
    }

    @Test
    public void testResolveAndOpenCloseInputStream() throws Exception {
        this.resolveAndOpenCloseInputStream();
        this.assertDelete();
    }

    @Test
    public void testResolveAndOpenCloseInputStream3() throws Exception {
        this.resolveAndOpenCloseInputStream();
        this.resolveAndOpenCloseInputStream();
        this.resolveAndOpenCloseInputStream();
        this.assertDelete();
    }

    @Test
    public void testResolveAndOpenReadCloseInputStream() throws Exception {
        this.resolveAndOpenReadCloseInputStream();
        this.assertDelete();
    }

    @Test
    public void testResolveAndOpenReadCloseInputStream3() throws Exception {
        this.resolveAndOpenReadCloseInputStream();
        this.resolveAndOpenReadCloseInputStream();
        this.resolveAndOpenReadCloseInputStream();
        this.assertDelete();
    }

    @Test
    public void testResolveOpenCloseNestedInputStreams() throws Exception {
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);){
            try (FileObject zipFileObject2 = this.manager.resolveFile(this.zipFileUri);){
                zipFileObject2.getContent().getInputStream().close();
            }
            zipFileObject.getContent().getInputStream().close();
        }
        this.assertDelete();
    }
}

