/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ZipFileObjectTestCase {
    private static final String NESTED_FILE_1 = "/read-xml-tests/file1.xml";
    private static final String NESTED_FILE_2 = "/read-xml-tests/file2.xml";

    private void assertDelete(File fileObject) {
        Assert.assertTrue((String)"Could not delete file", (boolean)fileObject.delete());
    }

    private File createTempFile() throws IOException {
        File zipFile = new File("src/test/resources/test-data/read-xml-tests.zip");
        File newZipFile = File.createTempFile(this.getClass().getSimpleName(), ".zip");
        newZipFile.deleteOnExit();
        FileUtils.copyFile((File)zipFile, (File)newZipFile);
        return newZipFile;
    }

    private void getInputStreamAndAssert(FileObject fileObject, String expectedId) throws FileSystemException, IOException {
        this.readAndAssert(fileObject, fileObject.getContent().getInputStream(), expectedId);
    }

    private void readAndAssert(FileObject fileObject, InputStream inputStream, String expectedId) throws IOException {
        String streamData = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        String fileObjectString = fileObject.toString();
        Assert.assertNotNull((String)fileObjectString, (Object)streamData);
        Assert.assertEquals((String)fileObjectString, (Object)("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<Root" + expectedId + ">foo" + expectedId + "</Root" + expectedId + ">\r\n"), (Object)streamData);
    }

    private void resolveReadAssert(FileObject zipFileObject, String path) throws IOException, FileSystemException {
        try (FileObject zipFileObject2 = zipFileObject.resolveFile(path);
             InputStream inputStream = zipFileObject2.getContent().getInputStream();){
            this.readAndAssert(zipFileObject2, inputStream, "2");
        }
    }

    @Test
    @Ignore(value="Shows that leaving a stream open and not closing any resource leaves the container file locked")
    public void testLeaveNestedFileOpen() throws IOException {
        File newZipFile = this.createTempFile();
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile("zip:file:" + newZipFile.getAbsolutePath());){
            FileObject zipFileObject1 = zipFileObject.resolveFile(NESTED_FILE_1);
            this.getInputStreamAndAssert(zipFileObject1, "1");
        }
        this.assertDelete(newZipFile);
    }

    @Test
    public void testReadingFilesInZipFile() throws IOException {
        File newZipFile = this.createTempFile();
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile("zip:file:" + newZipFile.getAbsolutePath());){
            try (FileObject zipFileObject1 = zipFileObject.resolveFile(NESTED_FILE_1);
                 InputStream inputStream = zipFileObject1.getContent().getInputStream();){
                this.readAndAssert(zipFileObject1, inputStream, "1");
            }
            this.resolveReadAssert(zipFileObject, NESTED_FILE_2);
        }
        this.assertDelete(newZipFile);
    }

    @Test
    public void testReadingOneAfterClosingAnotherFile() throws IOException {
        InputStream inputStream1;
        FileObject zipFileObject1;
        File newZipFile = this.createTempFile();
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile("zip:file:" + newZipFile.getAbsolutePath());){
            zipFileObject1 = zipFileObject.resolveFile(NESTED_FILE_1);
            inputStream1 = zipFileObject1.getContent().getInputStream();
        }
        this.readAndAssert(zipFileObject1, inputStream1, "1");
        zipFileObject1.close();
        this.assertDelete(newZipFile);
    }

    @Test
    public void testReadingOneAfterClosingAnotherStream() throws IOException {
        InputStream inputStream1;
        FileObject zipFileObject1;
        File newZipFile = this.createTempFile();
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile("zip:file:" + newZipFile.getAbsolutePath());){
            zipFileObject1 = zipFileObject.resolveFile(NESTED_FILE_1);
            inputStream1 = zipFileObject1.getContent().getInputStream();
            this.resolveReadAssert(zipFileObject, NESTED_FILE_2);
        }
        this.readAndAssert(zipFileObject1, inputStream1, "1");
        zipFileObject1.close();
        this.assertDelete(newZipFile);
    }

    @Test
    public void testReadSpecialNameFileInZipFile() throws FileSystemException {
        File testFile = new File("src/test/resources/test-data/special_fileName.zip");
        String[] fileNames = new String[]{"file.txt", "file^.txt", "file~.txt", "file?.txt", "file@.txt", "file$.txt", "file*.txt", "file&.txt", "file#.txt", "file%.txt", "file!.txt"};
        FileSystemManager manager = VFS.getManager();
        String baseUrl = "zip:file:" + testFile.getAbsolutePath();
        try (FileObject fileObject = manager.resolveFile(baseUrl);){
            Assert.assertEquals((long)fileObject.getChildren().length, (long)fileNames.length);
            for (String fileName : fileNames) {
                Assert.assertNotNull((String)("can't read file " + fileName), (Object)fileObject.getChild(fileName));
            }
        }
    }

    @Test
    public void testResolveNestedFileWithoutCleanup() throws IOException {
        File newZipFile = this.createTempFile();
        FileSystemManager manager = VFS.getManager();
        try (FileObject zipFileObject = manager.resolveFile("zip:file:" + newZipFile.getAbsolutePath());){
            FileObject fileObject = zipFileObject.resolveFile(NESTED_FILE_1);
        }
        this.assertDelete(newZipFile);
    }
}

