/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.File;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.WeakRefFilesCache;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.junit.Assert;
import org.junit.Test;

public class ZipFileSystemTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testZipFileUseWeakRefFilesCache() throws FileSystemException {
        File file = new File("src/test/resources/test-data/test.zip");
        String fileUri = "zip:file:" + file.getAbsolutePath();
        FileObject fileObject = null;
        try (StandardFileSystemManager manager = new StandardFileSystemManager();){
            WeakRefFilesCache filesCache = new WeakRefFilesCache();
            manager.setFilesCache((FilesCache)filesCache);
            manager.init();
            for (int cnt = 0; cnt < 100000; ++cnt) {
                try {
                    fileObject = manager.resolveFile(fileUri);
                    Assert.assertTrue((boolean)fileObject.exists());
                    continue;
                }
                finally {
                    if (fileObject != null) {
                        fileObject.close();
                    }
                    fileObject = null;
                }
            }
        }
    }
}

