/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.impl.StandardFileSystemManager;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.TrustEveryoneUserInfo;
import org.apache.commons.vfs2.util.DelegatingFileSystemOptionsBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DelegatingFileSystemOptionsBuilderTest {
    private static final String[] schemes = new String[]{"http", "ftp", "file", "zip", "tar", "tgz", "bz2", "gz", "jar", "tmp", "ram"};
    private StandardFileSystemManager fsm;

    @Before
    public void setUp() throws Exception {
        this.fsm = new StandardFileSystemManager();
        this.fsm.init();
    }

    @After
    public void tearDown() throws Exception {
        if (this.fsm != null) {
            this.fsm.close();
        }
    }

    @Test
    public void testConfiguration() throws Exception {
        for (String scheme : schemes) {
            Assert.assertTrue((String)("Missing " + scheme + " provider"), (boolean)this.fsm.hasProvider(scheme));
        }
    }

    @Test
    public void testDelegatingBad() throws Throwable {
        FileSystemOptions opts = new FileSystemOptions();
        DelegatingFileSystemOptionsBuilder delgate = new DelegatingFileSystemOptionsBuilder((FileSystemManager)this.fsm);
        try {
            delgate.setConfigString(opts, "http", "proxyPort", "wrong_port");
            Assert.fail();
        }
        catch (FileSystemException e) {
            Assert.assertSame(e.getCause().getClass(), InvocationTargetException.class);
            Assert.assertSame(((InvocationTargetException)e.getCause()).getTargetException().getClass(), NumberFormatException.class);
        }
        try {
            delgate.setConfigClass(opts, "sftp", "userinfo", String.class);
            Assert.fail();
        }
        catch (FileSystemException e) {
            Assert.assertEquals((Object)e.getCode(), (Object)"vfs.provider/config-value-invalid.error");
        }
    }

    @Test
    public void testDelegatingGood() throws Throwable {
        String[] identityPaths = new String[]{"/file1", "/file2"};
        FileSystemOptions opts = new FileSystemOptions();
        DelegatingFileSystemOptionsBuilder delgate = new DelegatingFileSystemOptionsBuilder((FileSystemManager)this.fsm);
        delgate.setConfigString(opts, "http", "proxyHost", "proxy");
        delgate.setConfigString(opts, "http", "proxyPort", "8080");
        delgate.setConfigClass(opts, "sftp", "userinfo", TrustEveryoneUserInfo.class);
        delgate.setConfigStrings(opts, "sftp", "identities", identityPaths);
        Assert.assertEquals((String)"http.proxyHost", (Object)HttpFileSystemConfigBuilder.getInstance().getProxyHost(opts), (Object)"proxy");
        Assert.assertEquals((String)"http.proxyPort", (long)HttpFileSystemConfigBuilder.getInstance().getProxyPort(opts), (long)8080L);
        Assert.assertSame((String)"sftp.userInfo", SftpFileSystemConfigBuilder.getInstance().getUserInfo(opts).getClass(), TrustEveryoneUserInfo.class);
        File[] identities = SftpFileSystemConfigBuilder.getInstance().getIdentities(opts);
        Assert.assertNotNull((String)"sftp.identities", (Object)identities);
        Assert.assertEquals((String)"sftp.identities size", (long)identities.length, (long)identityPaths.length);
        for (int iterIdentities = 0; iterIdentities < identities.length; ++iterIdentities) {
            Assert.assertEquals((String)("sftp.identities #" + iterIdentities), (Object)identities[iterIdentities].getAbsolutePath(), (Object)new File(identityPaths[iterIdentities]).getAbsolutePath());
        }
    }
}

