/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.http.test;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.http.HttpFileProvider;
import org.apache.commons.vfs2.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs2.test.AbstractProviderTestConfig;
import org.apache.commons.vfs2.test.ProviderTestSuite;
import org.apache.commons.vfs2.util.FreeSocketPortUtil;
import org.apache.commons.vfs2.util.NHttpServer;
import org.junit.Assert;

public class HttpProviderTestCase
extends AbstractProviderTestConfig {
    private static NHttpServer Server;
    private static int SocketPort;
    private static final String TEST_URI = "test.http.uri";
    private static String ConnectionUri;

    private static String getSystemTestUriOverride() {
        return System.getProperty(TEST_URI);
    }

    private static void setUpClass() throws Exception {
        Server = new NHttpServer();
        if (!Server.run(SocketPort, new File(HttpProviderTestCase.getTestDirectory()), 5000L)) {
            throw new IllegalStateException("The embedded HTTP server has not completed startup, increase wait time");
        }
    }

    public static Test suite() throws Exception {
        return new ProviderTestSuite(new HttpProviderTestCase()){

            @Override
            protected void addBaseTests() throws Exception {
                super.addBaseTests();
                this.addTests(HttpProviderTestCase.class);
            }

            @Override
            protected void setUp() throws Exception {
                if (HttpProviderTestCase.getSystemTestUriOverride() == null) {
                    HttpProviderTestCase.setUpClass();
                }
                super.setUp();
            }

            @Override
            protected void tearDown() throws Exception {
                HttpProviderTestCase.tearDownClass();
                super.tearDown();
            }
        };
    }

    private static void tearDownClass() throws IOException {
        if (Server != null) {
            Server.stop();
        }
    }

    public HttpProviderTestCase() throws IOException {
        SocketPort = FreeSocketPortUtil.findFreeLocalPort();
        ConnectionUri = "http://localhost:" + SocketPort;
    }

    private void checkReadTestsFolder(FileObject file) throws FileSystemException {
        Assert.assertNotNull((Object)file.getChildren());
        Assert.assertTrue((file.getChildren().length > 0 ? 1 : 0) != 0);
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        String uri = HttpProviderTestCase.getSystemTestUriOverride();
        if (uri == null) {
            uri = ConnectionUri;
        }
        return manager.resolveFile(uri);
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("http", (FileProvider)new HttpFileProvider());
    }

    private void testResloveFolderSlash(String uri, boolean followRedirect) throws FileSystemException {
        VFS.getManager().getFilesCache().close();
        FileSystemOptions opts = new FileSystemOptions();
        HttpFileSystemConfigBuilder.getInstance().setFollowRedirect(opts, followRedirect);
        FileObject file = VFS.getManager().resolveFile(uri, opts);
        try {
            this.checkReadTestsFolder(file);
        }
        catch (FileNotFolderException e) {
            // empty catch block
        }
    }

    public void testResloveFolderSlashNoRedirectOff() throws FileSystemException {
        this.testResloveFolderSlash(ConnectionUri + "/read-tests", false);
    }

    public void testResloveFolderSlashNoRedirectOn() throws FileSystemException {
        this.testResloveFolderSlash(ConnectionUri + "/read-tests", true);
    }

    public void testResloveFolderSlashYesRedirectOff() throws FileSystemException {
        this.testResloveFolderSlash(ConnectionUri + "/read-tests/", false);
    }

    public void testResloveFolderSlashYesRedirectOn() throws FileSystemException {
        this.testResloveFolderSlash(ConnectionUri + "/read-tests/", true);
    }

    public void ignoreTestHttp405() throws FileSystemException {
        FileObject f = VFS.getManager().resolveFile("http://www.w3schools.com/webservices/tempconvert.asmx?action=WSDL");
        assert (f.getContent().getSize() > 0L);
    }

    public void testHttpTimeoutConfig() throws FileSystemException {
        FileSystemOptions opts = new FileSystemOptions();
        HttpFileSystemConfigBuilder builder = HttpFileSystemConfigBuilder.getInstance();
        HttpProviderTestCase.assertEquals((int)0, (int)builder.getConnectionTimeout(opts));
        HttpProviderTestCase.assertEquals((int)0, (int)builder.getSoTimeout(opts));
        HttpProviderTestCase.assertEquals((String)"Jakarta-Commons-VFS", (String)builder.getUserAgent(opts));
        builder.setConnectionTimeout(opts, 60000);
        builder.setSoTimeout(opts, 60000);
        builder.setUserAgent(opts, "foo/bar");
        HttpProviderTestCase.assertEquals((int)60000, (int)builder.getConnectionTimeout(opts));
        HttpProviderTestCase.assertEquals((int)60000, (int)builder.getSoTimeout(opts));
        HttpProviderTestCase.assertEquals((String)"foo/bar", (String)builder.getUserAgent(opts));
    }
}

