/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local.test;

import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;

public class UrlTests
extends AbstractProviderTestCase {
    public void testHashFindFiles() throws Exception {
        FileSystemManager fsManager = VFS.getManager();
        FileObject[] foList = this.getBaseFolder().findFiles(Selectors.SELECT_FILES);
        boolean hashFileFound = false;
        for (FileObject fo : foList) {
            if (!fo.getURL().toString().contains("test-hash")) continue;
            hashFileFound = true;
            UrlTests.assertEquals((String)fo.toString(), (String)UriParser.decode((String)fo.getURL().toString()));
        }
        if (!hashFileFound) {
            UrlTests.fail((String)"Test hash file containing 'test-hash' not found");
        }
    }

    public void testHashURL() throws Exception {
        FileObject file = this.getReadFolder().resolveFile("test-hash-#test.txt");
        UrlTests.assertEquals((String)file.toString(), (String)UriParser.decode((String)file.getURL().toString()));
    }
}

