/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local.test;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.local.WindowsFileName;
import org.apache.commons.vfs2.test.AbstractProviderTestCase;

public class WindowsFileNameTests
extends AbstractProviderTestCase {
    public void testWindowsRoots() throws Exception {
        String[] tests;
        for (String name : tests = new String[]{"file:///C:/", "file://C:/", "file:/C:/", "file:C:/"}) {
            FileName fn = this.getManager().resolveFile(name).getName();
            WindowsFileNameTests.assertSame(WindowsFileName.class, fn.getClass());
            WindowsFileNameTests.assertEquals((String)"file:///C:/", (String)fn.toString());
            WindowsFileNameTests.assertEquals((String)"/", (String)fn.getPath());
            WindowsFileNameTests.assertEquals((String)"/", (String)fn.getPathDecoded());
            WindowsFileNameTests.assertEquals((String)"file:///C:/", (String)fn.getRootURI());
            WindowsFileNameTests.assertEquals((String)"file:///C:/", (String)fn.getFriendlyURI());
            WindowsFileNameTests.assertEquals((String)"file:///C:/", (String)fn.getRoot().toString());
            WindowsFileNameTests.assertEquals((String)"", (String)fn.getExtension());
            WindowsFileNameTests.assertEquals((String)"", (String)fn.getBaseName());
        }
    }

    public void testWindowsWrongRoots() throws Exception {
        String[] tests;
        for (String name : tests = new String[]{"file:///C:", "file://C:", "file:/C:", "file:C:"}) {
            try {
                FileName fn = this.getManager().resolveFile(name).getName();
                WindowsFileNameTests.fail((String)("should not accept root " + name));
            }
            catch (FileSystemException ex) {
                WindowsFileNameTests.assertEquals((String)"vfs.provider/invalid-absolute-uri.error", (String)ex.getCode());
                WindowsFileNameTests.assertTrue((ex.toString().indexOf(name) >= 0 ? 1 : 0) != 0);
            }
        }
    }

    public void testWindowsFilenameUNCStartError() throws Exception {
        try {
            String FILE = "file://///";
            FileObject fo = this.getManager().resolveFile("file://///");
            WindowsFileNameTests.fail((String)("Windows File Parser should not allow file:///// " + fo));
        }
        catch (FileSystemException ex) {
            WindowsFileNameTests.assertEquals((String)"Exception code", (String)"vfs.provider/invalid-absolute-uri.error", (String)ex.getCode());
            ex = (FileSystemException)ex.getCause();
            WindowsFileNameTests.assertEquals((String)"Exception code", (String)"vfs.provider.local/missing-share-name.error", (String)ex.getCode());
        }
    }

    public void testWindowsFilenameParserError() throws Exception {
        try {
            String FILE = "file://////";
            FileObject fo = this.getManager().resolveFile("file://////");
            WindowsFileNameTests.fail((String)("Windows File Parser should not allow file:////// " + fo));
        }
        catch (FileSystemException ex) {
            WindowsFileNameTests.assertEquals((String)"Exception code", (String)"vfs.provider/invalid-absolute-uri.error", (String)ex.getCode());
            ex = (FileSystemException)ex.getCause();
            WindowsFileNameTests.assertEquals((String)"Exception code", (String)"vfs.provider.local/not-absolute-file-name.error", (String)ex.getCode());
        }
    }
}

