/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.Executors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.io.IOUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultHttpServerIODispatch;
import org.apache.http.impl.nio.DefaultNHttpServerConnectionFactory;
import org.apache.http.impl.nio.SSLNHttpServerConnectionFactory;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpConnectionFactory;
import org.apache.http.nio.NHttpServerConnection;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.entity.NFileEntity;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.BasicAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerRegistry;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerResolver;
import org.apache.http.nio.protocol.HttpAsyncResponseProducer;
import org.apache.http.nio.protocol.HttpAsyncService;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.params.HttpParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;

public class NHttpServer {
    static final boolean Debug = false;
    volatile ListeningIOReactor ioReactor;

    private static void debug(String s) {
    }

    public static void main(String[] args) throws Exception {
        new NHttpServer().run(Integer.valueOf(args[0]), new File(args[1]), 0L);
    }

    public boolean run(final int port, final File docRoot, long waitMillis) throws IOReactorException, InterruptedException {
        Executors.newSingleThreadExecutor().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    NHttpServer.this.runBlock(port, docRoot);
                }
                catch (IOReactorException e) {
                    throw new IllegalStateException(e);
                }
                catch (UnrecoverableKeyException e) {
                    throw new IllegalStateException(e);
                }
                catch (KeyStoreException e) {
                    throw new IllegalStateException(e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new IllegalStateException(e);
                }
                catch (CertificateException e) {
                    throw new IllegalStateException(e);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                catch (KeyManagementException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
        return this.waitForServerStartup(port, waitMillis);
    }

    public void runBlock(int port, File docRoot) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
        DefaultNHttpServerConnectionFactory connFactory;
        if (docRoot == null) {
            throw new IllegalArgumentException("No doc root specified.");
        }
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        params.setIntParameter("http.socket.timeout", 5000).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"HttpTest/1.1");
        ImmutableHttpProcessor httpproc = new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseDate(), new ResponseServer(), new ResponseContent(), new ResponseConnControl()});
        HttpAsyncRequestHandlerRegistry reqistry = new HttpAsyncRequestHandlerRegistry();
        reqistry.register("*", (HttpAsyncRequestHandler)new HttpFileHandler(docRoot));
        HttpAsyncService protocolHandler = new HttpAsyncService((HttpProcessor)httpproc, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpAsyncRequestHandlerResolver)reqistry, (HttpParams)params){

            public void closed(NHttpServerConnection conn) {
                NHttpServer.debug(conn + ": connection closed");
                super.closed(conn);
            }

            public void connected(NHttpServerConnection conn) {
                NHttpServer.debug(conn + ": connection open");
                super.connected(conn);
            }
        };
        if (port == 8443) {
            ClassLoader cl = NHttpServer.class.getClassLoader();
            URL url = cl.getResource("my.keystore");
            if (url == null) {
                NHttpServer.debug("Keystore not found");
                System.exit(1);
            }
            KeyStore keystore = KeyStore.getInstance("jks");
            keystore.load(url.openStream(), "secret".toCharArray());
            KeyManagerFactory kmfactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmfactory.init(keystore, "secret".toCharArray());
            KeyManager[] keymanagers = kmfactory.getKeyManagers();
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(keymanagers, null, null);
            connFactory = new SSLNHttpServerConnectionFactory(sslcontext, null, (HttpParams)params);
        } else {
            connFactory = new DefaultNHttpServerConnectionFactory((HttpParams)params);
        }
        DefaultHttpServerIODispatch ioEventDispatch = new DefaultHttpServerIODispatch((NHttpServerEventHandler)protocolHandler, (NHttpConnectionFactory)connFactory);
        this.ioReactor = new DefaultListeningIOReactor();
        try {
            this.ioReactor.listen((SocketAddress)new InetSocketAddress(port));
            this.ioReactor.execute((IOEventDispatch)ioEventDispatch);
        }
        catch (InterruptedIOException ex) {
            System.err.println("Interrupted");
        }
        catch (IOException e) {
            System.err.println("I/O error: " + e.getMessage());
        }
        NHttpServer.debug("Shutdown");
    }

    public void stop() throws IOException {
        if (this.ioReactor != null) {
            this.ioReactor.shutdown(2000L);
        }
    }

    private boolean waitForServerStartup(int port, long waitMillis) throws InterruptedException {
        long endWait = System.currentTimeMillis() + waitMillis;
        String urlSpec = "http://localhost:" + port;
        try {
            URL url = new URL(urlSpec);
            InputStream inputStream = null;
            while (System.currentTimeMillis() < endWait && inputStream == null) {
                try {
                    inputStream = url.openStream();
                    if (inputStream != null) {
                        IOUtils.closeQuietly((InputStream)inputStream);
                        return true;
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                Thread.sleep(100L);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Error in test code for URL " + urlSpec);
        }
        return false;
    }

    static class HttpFileHandler
    implements HttpAsyncRequestHandler<HttpRequest> {
        private final File docRoot;

        public HttpFileHandler(File docRoot) {
            this.docRoot = docRoot;
        }

        public void handle(HttpRequest request, HttpAsyncExchange httpexchange, HttpContext context) throws HttpException, IOException {
            HttpResponse response = httpexchange.getResponse();
            this.handleInternal(request, response, context);
            httpexchange.submitResponse((HttpAsyncResponseProducer)new BasicAsyncResponseProducer(response));
        }

        private void handleInternal(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String method = request.getRequestLine().getMethod().toUpperCase(Locale.ENGLISH);
            if (!(method.equals("GET") || method.equals("HEAD") || method.equals("POST"))) {
                throw new MethodNotSupportedException(method + " method not supported");
            }
            String target = request.getRequestLine().getUri();
            File file = new File(this.docRoot, URLDecoder.decode(target, "UTF-8"));
            if (!file.exists()) {
                response.setStatusCode(404);
                NStringEntity entity = new NStringEntity("<html><body><h1>File" + file.getPath() + " not found</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
                response.setEntity((HttpEntity)entity);
                NHttpServer.debug("File " + file.getPath() + " not found");
            } else if (!file.canRead()) {
                response.setStatusCode(403);
                NStringEntity entity = new NStringEntity("<html><body><h1>Access denied</h1></body></html>", ContentType.create((String)"text/html", (String)"UTF-8"));
                response.setEntity((HttpEntity)entity);
                NHttpServer.debug("Cannot read file " + file.getPath());
            } else {
                NHttpConnection conn = (NHttpConnection)context.getAttribute("http.connection");
                response.setStatusCode(200);
                NFileEntity body = new NFileEntity(file, ContentType.create((String)"text/html"));
                response.setEntity((HttpEntity)body);
                if (!response.containsHeader("Last-Modified")) {
                    response.addHeader("Last-Modified", DateUtil.formatDate((Date)new Date(file.lastModified())));
                }
                NHttpServer.debug(conn + ": serving file " + file.getPath());
            }
        }

        public HttpAsyncRequestConsumer<HttpRequest> processRequest(HttpRequest request, HttpContext context) {
            return new BasicAsyncRequestConsumer();
        }
    }
}

