/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.cache;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FilesCache;
import org.apache.commons.vfs2.cache.AbstractFilesCacheTestsBase;
import org.apache.commons.vfs2.cache.NullFilesCache;

public class NullFilesCacheTests
extends AbstractFilesCacheTestsBase {
    public void testFilesCache() throws Exception {
        FileObject dir1_2;
        FileObject scratchFolder = this.getWriteFolder();
        FileObject dir1 = scratchFolder.resolveFile("dir1");
        NullFilesCacheTests.assertFalse((String)"Should always be new instance with NullCache", (dir1 == (dir1_2 = scratchFolder.resolveFile("dir1")) ? 1 : 0) != 0);
    }

    @Override
    public void testBasicCacheOps() throws Exception {
        FilesCache cache = this.getManager().getFilesCache();
        FileObject fo = this.getWriteFolder().resolveFile("dir1");
        FileName fn = fo.getName();
        FileSystem fs = fo.getFileSystem();
        cache.clear(fs);
        NullFilesCacheTests.assertNull((Object)cache.getFile(fs, fn));
        cache.putFile(fo);
        NullFilesCacheTests.assertNull(null, (Object)cache.getFile(fs, fn));
        NullFilesCacheTests.assertFalse((boolean)cache.putFileIfAbsent(fo));
        NullFilesCacheTests.assertNull(null, (Object)cache.getFile(fs, fn));
        cache.removeFile(fs, fn);
        NullFilesCacheTests.assertNull((Object)cache.getFile(fs, fn));
    }

    public void testClass() {
        NullFilesCacheTests.assertTrue((boolean)(this.getManager().getFilesCache() instanceof NullFilesCache));
    }
}

