/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.impl.test;

import java.io.File;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.junit.Test;

public class DefaultFileSystemManagerTest {
    @Test(expected=NullPointerException.class)
    public void testResolveFileRelativeThrows() throws FileSystemException {
        VFS.getManager().resolveFile((File)null, "relativePath");
    }

    @Test(expected=NullPointerException.class)
    public void testResolveFileAbsoluteThrows() throws FileSystemException {
        String absolute = new File("/").getAbsoluteFile().toURI().toString();
        VFS.getManager().resolveFile((File)null, absolute);
    }

    @Test(expected=FileSystemException.class)
    public void testResolveFileObjectRelativeThrows() throws FileSystemException {
        VFS.getManager().resolveFile((FileObject)null, "relativePath");
    }

    @Test
    public void testResolveFileObjectNullAbsolute() throws FileSystemException {
        String absolute = new File("/").getAbsoluteFile().toURI().toString();
        VFS.getManager().resolveFile((FileObject)null, absolute);
    }

    @Test(expected=FileSystemException.class)
    public void testResolveFileNameNull() throws FileSystemException {
        VFS.getManager().resolveName((FileName)null, "../");
    }
}

