/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver;

import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.apache.commons.weaver.Finder;
import org.apache.commons.weaver.LocalWeaveEnvironment;
import org.apache.commons.weaver.ant._lang3.Validate;
import org.apache.commons.weaver.ant._xbean.finder.archive.FileArchive;
import org.apache.commons.weaver.spi.Cleaner;
import org.apache.commons.weaver.utils.URLArray;

public class CleanProcessor {
    private static final Logger LOG = Logger.getLogger(CleanProcessor.class.getName());
    private static final List<Cleaner> CLEANERS;
    private final List<String> classpath;
    private final File target;
    private final Properties configuration;

    public CleanProcessor(List<String> classpath, File target, Properties configuration) {
        this.classpath = Validate.notNull(classpath, "classpath", new Object[0]);
        this.target = Validate.notNull(target, "target", new Object[0]);
        Validate.isTrue(!target.exists() || target.isDirectory(), "%s is not a directory", target);
        this.configuration = Validate.notNull(configuration, "configuration", new Object[0]);
    }

    public void clean() {
        if (!this.target.exists()) {
            LOG.warning("Target directory " + this.target + " does not exist; nothing to do!");
        }
        LinkedHashSet<String> finderClasspath = new LinkedHashSet<String>();
        finderClasspath.add(this.target.getAbsolutePath());
        finderClasspath.addAll(this.classpath);
        URLClassLoader classLoader = new URLClassLoader(URLArray.fromPaths(finderClasspath));
        Finder finder = new Finder(new FileArchive((ClassLoader)classLoader, this.target));
        for (Cleaner cleaner : CLEANERS) {
            LocalWeaveEnvironment env = new LocalWeaveEnvironment(this.target, classLoader, this.configuration, Logger.getLogger(cleaner.getClass().getName()));
            cleaner.clean(env, finder);
        }
    }

    static {
        ArrayList<Cleaner> cleaners = new ArrayList<Cleaner>();
        for (Cleaner cleaner : ServiceLoader.load(Cleaner.class)) {
            cleaners.add(cleaner);
        }
        CLEANERS = Collections.unmodifiableList(cleaners);
    }
}

