/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.weaver.ant._xbean.finder.AnnotationFinder;
import org.apache.commons.weaver.ant._xbean.finder.Parameter;
import org.apache.commons.weaver.model.ScanResult;
import org.apache.commons.weaver.model.WeavableClass;
import org.apache.commons.weaver.model.WeavableConstructor;
import org.apache.commons.weaver.model.WeavableConstructorParameter;
import org.apache.commons.weaver.model.WeavableField;
import org.apache.commons.weaver.model.WeavableMethod;
import org.apache.commons.weaver.model.WeavableMethodParameter;
import org.apache.commons.weaver.model.WeavablePackage;

class Inflater {
    final Map<AnnotationFinder.PackageInfo, List<Annotation>> packageAnnotations;
    final Map<AnnotationFinder.ClassInfo, List<Annotation>> classAnnotations;
    final Map<AnnotationFinder.FieldInfo, List<Annotation>> fieldAnnotations;
    final Map<AnnotationFinder.MethodInfo, List<Annotation>> ctorAnnotations;
    final Map<AnnotationFinder.MethodInfo, List<Annotation>> methodAnnotations;
    final Map<AnnotationFinder.ParameterInfo, List<Annotation>> ctorParameterAnnotations;
    final Map<AnnotationFinder.ParameterInfo, List<Annotation>> methodParameterAnnotations;

    Inflater(Map<AnnotationFinder.Info, List<Annotation>> annotationMap) {
        this.packageAnnotations = Inflater.subMap(annotationMap, new InfoMatcher(AnnotationFinder.PackageInfo.class));
        this.classAnnotations = Inflater.subMap(annotationMap, new InfoMatcher(AnnotationFinder.ClassInfo.class));
        this.fieldAnnotations = Inflater.subMap(annotationMap, new InfoMatcher(AnnotationFinder.FieldInfo.class));
        this.ctorAnnotations = Inflater.subMap(annotationMap, new MethodMatcher(true));
        this.methodAnnotations = Inflater.subMap(annotationMap, new MethodMatcher(false));
        this.ctorParameterAnnotations = Inflater.subMap(annotationMap, new ParameterMatcher(true));
        this.methodParameterAnnotations = Inflater.subMap(annotationMap, new ParameterMatcher(false));
    }

    static <I extends AnnotationFinder.Info> Map<I, List<Annotation>> subMap(Map<AnnotationFinder.Info, List<Annotation>> source, InfoMatcher matcher) {
        HashMap<AnnotationFinder.Info, List<Annotation>> result = new HashMap<AnnotationFinder.Info, List<Annotation>>();
        for (Map.Entry<AnnotationFinder.Info, List<Annotation>> entry : source.entrySet()) {
            if (!matcher.test(entry.getKey())) continue;
            AnnotationFinder.Info key = entry.getKey();
            result.put(key, entry.getValue());
        }
        return result;
    }

    ScanResult inflate(ScanResult scanResult) {
        for (WeavablePackage pkg : scanResult.getPackages()) {
            for (Map.Entry<AnnotationFinder.PackageInfo, List<Annotation>> entry : this.packageAnnotations.entrySet()) {
                if (!entry.getKey().getName().equals(((Package)pkg.getTarget()).getName())) continue;
                pkg.addAnnotations((Iterable<Annotation>)entry.getValue());
            }
            for (WeavableClass weavableClass : pkg.getClasses()) {
                Parameter<?> parameter;
                for (Map.Entry<AnnotationFinder.ClassInfo, List<Annotation>> entry : this.classAnnotations.entrySet()) {
                    if (!entry.getKey().getName().equals(((Class)weavableClass.getTarget()).getName())) continue;
                    weavableClass.addAnnotations((Iterable<Annotation>)entry.getValue());
                }
                for (WeavableField weavableField : weavableClass.getFields()) {
                    for (Map.Entry<AnnotationFinder.FieldInfo, List<Annotation>> entry : this.fieldAnnotations.entrySet()) {
                        try {
                            if (!entry.getKey().get().equals(weavableField.getTarget())) continue;
                            weavableField.addAnnotations((Iterable<Annotation>)entry.getValue());
                        }
                        catch (ClassNotFoundException cnfe) {}
                    }
                }
                for (WeavableConstructor weavableConstructor : weavableClass.getConstructors()) {
                    for (Map.Entry<AnnotationFinder.Annotatable, List<Annotation>> entry : this.ctorAnnotations.entrySet()) {
                        try {
                            if (!((AnnotationFinder.MethodInfo)entry.getKey()).get().equals(weavableConstructor.getTarget())) continue;
                            weavableConstructor.addAnnotations((Iterable<Annotation>)entry.getValue());
                        }
                        catch (ClassNotFoundException cnfe) {}
                    }
                    for (WeavableConstructorParameter weavableConstructorParameter : weavableConstructor.getParameters()) {
                        for (Map.Entry<AnnotationFinder.ParameterInfo, List<Annotation>> entry : this.ctorParameterAnnotations.entrySet()) {
                            try {
                                parameter = entry.getKey().get();
                                if (!parameter.getDeclaringExecutable().equals(weavableConstructor.getTarget()) || ((Integer)weavableConstructorParameter.getTarget()).intValue() != parameter.getIndex()) continue;
                                weavableConstructorParameter.addAnnotations((Iterable<Annotation>)entry.getValue());
                            }
                            catch (ClassNotFoundException cnfe) {}
                        }
                    }
                }
                for (WeavableMethod weavableMethod : weavableClass.getMethods()) {
                    for (Map.Entry<AnnotationFinder.Annotatable, List<Annotation>> entry : this.methodAnnotations.entrySet()) {
                        try {
                            if (!((AnnotationFinder.MethodInfo)entry.getKey()).get().equals(weavableMethod.getTarget())) continue;
                            weavableMethod.addAnnotations((Iterable<Annotation>)entry.getValue());
                        }
                        catch (ClassNotFoundException cnfe) {}
                    }
                    for (WeavableMethodParameter weavableMethodParameter : weavableMethod.getParameters()) {
                        for (Map.Entry<AnnotationFinder.ParameterInfo, List<Annotation>> entry : this.methodParameterAnnotations.entrySet()) {
                            try {
                                parameter = entry.getKey().get();
                                if (!parameter.getDeclaringExecutable().equals(weavableMethod.getTarget()) || ((Integer)weavableMethodParameter.getTarget()).intValue() != parameter.getIndex()) continue;
                                weavableMethodParameter.addAnnotations((Iterable<Annotation>)entry.getValue());
                            }
                            catch (ClassNotFoundException cnfe) {}
                        }
                    }
                }
            }
        }
        return scanResult;
    }

    private class ParameterMatcher
    extends InfoMatcher {
        final boolean isCtor;

        ParameterMatcher(boolean isCtor) {
            super(AnnotationFinder.ParameterInfo.class);
            this.isCtor = isCtor;
        }

        @Override
        boolean test(AnnotationFinder.Info info) {
            return super.test(info) && ((AnnotationFinder.ParameterInfo)info).getDeclaringMethod().isConstructor() == this.isCtor;
        }
    }

    private class MethodMatcher
    extends InfoMatcher {
        final boolean isCtor;

        MethodMatcher(boolean isCtor) {
            super(AnnotationFinder.MethodInfo.class);
            this.isCtor = isCtor;
        }

        @Override
        boolean test(AnnotationFinder.Info info) {
            return super.test(info) && ((AnnotationFinder.MethodInfo)info).isConstructor() == this.isCtor;
        }
    }

    private class InfoMatcher {
        final Class<? extends AnnotationFinder.Info> type;

        InfoMatcher(Class<? extends AnnotationFinder.Info> type) {
            this.type = type;
        }

        boolean test(AnnotationFinder.Info info) {
            return this.type.isInstance(info);
        }
    }
}

