/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver;

import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.apache.commons.weaver.Finder;
import org.apache.commons.weaver.LocalWeaveEnvironment;
import org.apache.commons.weaver.ant._lang3.Validate;
import org.apache.commons.weaver.ant._xbean.finder.archive.FileArchive;
import org.apache.commons.weaver.spi.Weaver;
import org.apache.commons.weaver.utils.URLArray;

public class WeaveProcessor {
    private static final Logger LOG = Logger.getLogger(WeaveProcessor.class.getName());
    private static final List<Weaver> WEAVERS;
    private final List<String> classpath;
    private final File target;
    private final Properties configuration;

    public WeaveProcessor(List<String> classpath, File target, Properties configuration) {
        this.classpath = Validate.notNull(classpath, "classpath", new Object[0]);
        this.target = Validate.notNull(target, "target", new Object[0]);
        Validate.isTrue(!target.exists() || target.isDirectory(), "%s is not a directory", target);
        this.configuration = Validate.notNull(configuration, "configuration", new Object[0]);
    }

    public void weave() {
        if (!this.target.exists()) {
            LOG.warning("Target directory " + this.target + " does not exist; nothing to do!");
        }
        LinkedHashSet<String> finderClasspath = new LinkedHashSet<String>();
        finderClasspath.add(this.target.getAbsolutePath());
        finderClasspath.addAll(this.classpath);
        URLClassLoader classLoader = new URLClassLoader(URLArray.fromPaths(finderClasspath));
        Finder finder = new Finder(new FileArchive((ClassLoader)classLoader, this.target));
        for (Weaver weaver : WEAVERS) {
            LocalWeaveEnvironment env = new LocalWeaveEnvironment(this.target, classLoader, this.configuration, Logger.getLogger(weaver.getClass().getName()));
            weaver.process(env, finder);
        }
    }

    static {
        ArrayList<Weaver> weavers = new ArrayList<Weaver>();
        for (Weaver weaver : ServiceLoader.load(Weaver.class)) {
            weavers.add(weaver);
        }
        WEAVERS = Collections.unmodifiableList(weavers);
    }
}

