/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.privilizer;

import java.io.InputStream;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import org.apache.commons.weaver.model.ScanRequest;
import org.apache.commons.weaver.model.Scanner;
import org.apache.commons.weaver.model.WeavableClass;
import org.apache.commons.weaver.model.WeaveEnvironment;
import org.apache.commons.weaver.model.WeaveInterest;
import org.apache.commons.weaver.privilizer.Policy;
import org.apache.commons.weaver.privilizer.Privilized;
import org.apache.commons.weaver.privilizer.Privilizer;
import org.apache.commons.weaver.privilizer._asm.ClassReader;
import org.apache.commons.weaver.privilizer._asm.ClassVisitor;
import org.apache.commons.weaver.privilizer._io.IOUtils;
import org.apache.commons.weaver.spi.Cleaner;

public class PrivilizerCleaner
implements Cleaner {
    public boolean clean(WeaveEnvironment environment, Scanner scanner) {
        Privilizer privilizer = new Privilizer(environment);
        final ArrayList toDelete = new ArrayList();
        ScanRequest scanRequest = new ScanRequest().add(WeaveInterest.of(Privilized.class, (ElementType)ElementType.TYPE));
        environment.debug("Cleaning classes privilized with policy other than %s", new Object[]{privilizer.policy});
        for (WeavableClass weavableClass : scanner.scan(scanRequest).getClasses().with(Privilized.class)) {
            Policy privilizedPolicy = Policy.valueOf(((Privilized)weavableClass.getAnnotation(Privilized.class)).value());
            if (privilizedPolicy == privilizer.policy) continue;
            String className = ((Class)weavableClass.getTarget()).getName();
            environment.debug("Class %s privilized with %s; deleting.", new Object[]{className, privilizedPolicy});
            InputStream bytecode = null;
            try {
                bytecode = privilizer.env.getClassfile(className).getInputStream();
                ClassReader classReader = new ClassReader(bytecode);
                classReader.accept(new ClassVisitor(262144){

                    @Override
                    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                        toDelete.add(name);
                    }

                    @Override
                    public void visitInnerClass(String name, String outerName, String innerName, int access) {
                        if (toDelete.contains(outerName)) {
                            toDelete.add(name);
                        }
                    }
                }, 7);
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bytecode);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(bytecode);
        }
        boolean result = false;
        for (String className : toDelete) {
            String resourcePath = PrivilizerCleaner.toResourcePath(className);
            boolean success = environment.deleteResource(resourcePath);
            environment.debug("Deletion of resource %s was %ssuccessful.", new Object[]{resourcePath, success ? "" : "un"});
            result |= success;
        }
        return result;
    }

    private static String toResourcePath(String className) {
        return className.replace('.', '/') + ".class";
    }
}

