/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.weaver.Inflater;
import org.apache.commons.weaver.ant._lang3.ArrayUtils;
import org.apache.commons.weaver.ant._lang3.Validate;
import org.apache.commons.weaver.ant._xbean.asm4.AnnotationVisitor;
import org.apache.commons.weaver.ant._xbean.asm4.ClassReader;
import org.apache.commons.weaver.ant._xbean.asm4.ClassVisitor;
import org.apache.commons.weaver.ant._xbean.asm4.FieldVisitor;
import org.apache.commons.weaver.ant._xbean.asm4.MethodVisitor;
import org.apache.commons.weaver.ant._xbean.asm4.Type;
import org.apache.commons.weaver.ant._xbean.finder.Annotated;
import org.apache.commons.weaver.ant._xbean.finder.AnnotationFinder;
import org.apache.commons.weaver.ant._xbean.finder.Parameter;
import org.apache.commons.weaver.ant._xbean.finder.archive.Archive;
import org.apache.commons.weaver.model.ScanRequest;
import org.apache.commons.weaver.model.ScanResult;
import org.apache.commons.weaver.model.Scanner;
import org.apache.commons.weaver.model.WeavableConstructorParameter;
import org.apache.commons.weaver.model.WeavableMethodParameter;
import org.apache.commons.weaver.model.WeaveInterest;
import org.apache.commons.weaver.utils.Annotations;

class Finder
extends AnnotationFinder
implements Scanner {
    private static final int ASM_FLAGS = 7;
    private static final ThreadLocal<Map<AnnotationFinder.Info, List<Annotation>>> CLASSFILE_ANNOTATIONS = new ThreadLocal<Map<AnnotationFinder.Info, List<Annotation>>>(){

        @Override
        protected Map<AnnotationFinder.Info, List<Annotation>> initialValue() {
            return new IdentityHashMap<AnnotationFinder.Info, List<Annotation>>();
        }
    };
    private final WithAnnotations withAnnotations = new WithAnnotations();
    private final Map<AnnotationFinder.Info, List<Annotation>> classfileAnnotations = CLASSFILE_ANNOTATIONS.get();
    private final Inflater inflater;

    public Finder(Archive archive) {
        super(archive, false);
        CLASSFILE_ANNOTATIONS.remove();
        this.inflater = new Inflater(this.classfileAnnotations);
        this.enableFindImplementations();
        this.enableFindSubclasses();
    }

    public WithAnnotations withAnnotations() {
        return this.withAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readClassDef(InputStream bytecode) throws IOException {
        try {
            ClassReader classReader = new ClassReader(bytecode);
            classReader.accept(new Visitor(new AnnotationFinder.InfoBuildingVisitor(this)), 7);
        }
        finally {
            bytecode.close();
        }
    }

    @Override
    public AnnotationFinder select(Class<?> ... arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AnnotationFinder select(Iterable<String> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AnnotationFinder select(String ... clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScanResult scan(ScanRequest request) {
        ScanResult result = new ScanResult();
        block8: for (WeaveInterest weaveInterest : request.getInterests()) {
            switch (weaveInterest.target) {
                case PACKAGE: {
                    for (Annotated<AnnotatedElement> annotated : this.withAnnotations().findAnnotatedPackages(weaveInterest.annotationType)) {
                        result.getWeavable((Package)annotated.get()).addAnnotations(annotated.getAnnotations());
                    }
                    continue block8;
                }
                case TYPE: {
                    for (Annotated<AnnotatedElement> annotated : this.withAnnotations().findAnnotatedClasses(weaveInterest.annotationType)) {
                        result.getWeavable((Class)annotated.get()).addAnnotations(annotated.getAnnotations());
                    }
                    continue block8;
                }
                case METHOD: {
                    for (Annotated<AnnotatedElement> annotated : this.withAnnotations().findAnnotatedMethods(weaveInterest.annotationType)) {
                        result.getWeavable((Method)annotated.get()).addAnnotations(annotated.getAnnotations());
                    }
                    continue block8;
                }
                case CONSTRUCTOR: {
                    for (Annotated<AnnotatedElement> annotated : this.withAnnotations().findAnnotatedConstructors(weaveInterest.annotationType)) {
                        result.getWeavable((Constructor)annotated.get()).addAnnotations(annotated.getAnnotations());
                    }
                    continue block8;
                }
                case FIELD: {
                    for (Annotated<AnnotatedElement> annotated : this.withAnnotations().findAnnotatedFields(weaveInterest.annotationType)) {
                        result.getWeavable((Field)annotated.get()).addAnnotations(annotated.getAnnotations());
                    }
                    continue block8;
                }
                case PARAMETER: {
                    for (Annotated<AnnotatedElement> annotated : this.withAnnotations().findAnnotatedMethodParameters(weaveInterest.annotationType)) {
                        ((WeavableMethodParameter)result.getWeavable((Method)((Parameter)annotated.get()).getDeclaringExecutable()).getWeavableParameter(((Parameter)annotated.get()).getIndex())).addAnnotations(annotated.getAnnotations());
                    }
                    for (Annotated<AnnotatedElement> annotated : this.withAnnotations().findAnnotatedConstructorParameters(weaveInterest.annotationType)) {
                        ((WeavableConstructorParameter)result.getWeavable((Constructor)((Parameter)annotated.get()).getDeclaringExecutable()).getWeavableParameter(((Parameter)annotated.get()).getIndex())).addAnnotations(annotated.getAnnotations());
                    }
                    continue block8;
                }
            }
        }
        for (Class clazz : request.getSupertypes()) {
            for (Annotated<AnnotatedElement> annotated : this.withAnnotations().findAssignableTypes(clazz)) {
                result.getWeavable((Class)annotated.get()).addAnnotations(annotated.getAnnotations());
            }
        }
        return this.inflater.inflate(result);
    }

    private Class<?> toClass(Type type) {
        Class<?> result;
        String className = type.getSort() == 9 ? type.getElementType().getClassName() : type.getClassName();
        try {
            result = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            try {
                result = this.getArchive().loadClass(className);
            }
            catch (ClassNotFoundException e1) {
                throw new RuntimeException(e1);
            }
        }
        if (type.getSort() == 9) {
            int[] dims = new int[type.getDimensions()];
            Arrays.fill(dims, 0);
            result = Array.newInstance(result, dims).getClass();
        }
        return result;
    }

    public final class WithAnnotations {
        private static final String INIT = "<init>";

        private WithAnnotations() {
        }

        public List<Annotated<Package>> findAnnotatedPackages(Class<? extends Annotation> annotation) {
            Finder.this.findAnnotatedPackages(annotation);
            ArrayList<Annotated<Package>> result = new ArrayList<Annotated<Package>>();
            for (AnnotationFinder.Info info : Finder.this.getAnnotationInfos(annotation.getName())) {
                if (!(info instanceof AnnotationFinder.PackageInfo)) continue;
                AnnotationFinder.PackageInfo packageInfo = (AnnotationFinder.PackageInfo)info;
                try {
                    IncludesClassfile<Package> annotated = new IncludesClassfile<Package>(packageInfo.get(), this.classfileAnnotationsFor(packageInfo));
                    if (!annotated.isAnnotationPresent(annotation)) continue;
                    result.add(annotated);
                }
                catch (ClassNotFoundException e) {}
            }
            return result;
        }

        public List<Annotated<Class<?>>> findAnnotatedClasses(Class<? extends Annotation> annotation) {
            Finder.this.findAnnotatedClasses(annotation);
            ArrayList result = new ArrayList();
            for (AnnotationFinder.Info info : Finder.this.getAnnotationInfos(annotation.getName())) {
                IncludesClassfile annotated;
                if (!(info instanceof AnnotationFinder.ClassInfo)) continue;
                AnnotationFinder.ClassInfo classInfo = (AnnotationFinder.ClassInfo)info;
                try {
                    annotated = new IncludesClassfile(classInfo.get(), this.classfileAnnotationsFor(classInfo));
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                if (!annotated.isAnnotationPresent(annotation)) continue;
                result.add(annotated);
            }
            return result;
        }

        public List<Annotated<Class<?>>> findAssignableTypes(Class<?> supertype) {
            ArrayList result = new ArrayList();
            List<Class<?>> assignableTypes = supertype.isInterface() ? Finder.this.findImplementations(supertype) : Finder.this.findSubclasses(supertype);
            for (Class<?> object : assignableTypes) {
                IncludesClassfile annotated;
                AnnotationFinder.ClassInfo classInfo = (AnnotationFinder.ClassInfo)Finder.this.classInfos.get(object.getName());
                try {
                    annotated = new IncludesClassfile(classInfo.get(), this.classfileAnnotationsFor(classInfo));
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                result.add(annotated);
            }
            return result;
        }

        public List<Annotated<Method>> findAnnotatedMethods(Class<? extends Annotation> annotation) {
            Finder.this.findAnnotatedMethods(annotation);
            ArrayList<Annotated<Method>> result = new ArrayList<Annotated<Method>>();
            for (AnnotationFinder.Info info : Finder.this.getAnnotationInfos(annotation.getName())) {
                IncludesClassfile<Method> annotated;
                AnnotationFinder.MethodInfo methodInfo;
                if (!(info instanceof AnnotationFinder.MethodInfo) || INIT.equals((methodInfo = (AnnotationFinder.MethodInfo)info).getName())) continue;
                try {
                    annotated = new IncludesClassfile<Method>((Method)methodInfo.get(), this.classfileAnnotationsFor(methodInfo));
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                if (!annotated.isAnnotationPresent(annotation)) continue;
                result.add(annotated);
            }
            return result;
        }

        public List<Annotated<Parameter<Method>>> findAnnotatedMethodParameters(Class<? extends Annotation> annotationType) {
            Finder.this.findAnnotatedMethodParameters(annotationType);
            ArrayList<Annotated<Parameter<Method>>> result = new ArrayList<Annotated<Parameter<Method>>>();
            for (AnnotationFinder.Info info : Finder.this.getAnnotationInfos(annotationType.getName())) {
                Parameter<?> parameter;
                AnnotationFinder.ParameterInfo parameterInfo;
                if (!(info instanceof AnnotationFinder.ParameterInfo) || INIT.equals((parameterInfo = (AnnotationFinder.ParameterInfo)info).getDeclaringMethod().getName())) continue;
                try {
                    Parameter<?> unchecked;
                    parameter = unchecked = parameterInfo.get();
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                IncludesClassfile annotated = new IncludesClassfile(parameter, this.classfileAnnotationsFor(parameterInfo));
                if (!annotated.isAnnotationPresent(annotationType)) continue;
                result.add(annotated);
            }
            return result;
        }

        public List<Annotated<Constructor<?>>> findAnnotatedConstructors(Class<? extends Annotation> annotation) {
            Finder.this.findAnnotatedConstructors(annotation);
            ArrayList result = new ArrayList();
            for (AnnotationFinder.Info info : Finder.this.getAnnotationInfos(annotation.getName())) {
                IncludesClassfile<Constructor> annotated;
                AnnotationFinder.MethodInfo methodInfo;
                if (!(info instanceof AnnotationFinder.MethodInfo) || !INIT.equals((methodInfo = (AnnotationFinder.MethodInfo)info).getName())) continue;
                try {
                    annotated = new IncludesClassfile<Constructor>((Constructor)methodInfo.get(), this.classfileAnnotationsFor(methodInfo));
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                if (!annotated.isAnnotationPresent(annotation)) continue;
                result.add(annotated);
            }
            return result;
        }

        public List<Annotated<Parameter<Constructor<?>>>> findAnnotatedConstructorParameters(Class<? extends Annotation> annotation) {
            Finder.this.findAnnotatedConstructorParameters(annotation);
            ArrayList result = new ArrayList();
            for (AnnotationFinder.Info info : Finder.this.getAnnotationInfos(annotation.getName())) {
                Parameter<?> parameter;
                AnnotationFinder.ParameterInfo parameterInfo;
                if (!(info instanceof AnnotationFinder.ParameterInfo) || !INIT.equals((parameterInfo = (AnnotationFinder.ParameterInfo)info).getDeclaringMethod().getName())) continue;
                try {
                    Parameter<?> unchecked;
                    parameter = unchecked = parameterInfo.get();
                }
                catch (ClassNotFoundException e) {
                    continue;
                }
                IncludesClassfile annotated = new IncludesClassfile(parameter, this.classfileAnnotationsFor(parameterInfo));
                if (!annotated.isAnnotationPresent(annotation)) continue;
                result.add(annotated);
            }
            return result;
        }

        public List<Annotated<Field>> findAnnotatedFields(Class<? extends Annotation> annotation) {
            Finder.this.findAnnotatedFields(annotation);
            ArrayList<Annotated<Field>> result = new ArrayList<Annotated<Field>>();
            for (AnnotationFinder.Info info : Finder.this.getAnnotationInfos(annotation.getName())) {
                if (!(info instanceof AnnotationFinder.FieldInfo)) continue;
                AnnotationFinder.FieldInfo fieldInfo = (AnnotationFinder.FieldInfo)info;
                try {
                    IncludesClassfile<Field> annotated = new IncludesClassfile<Field>((Field)fieldInfo.get(), this.classfileAnnotationsFor(fieldInfo));
                    if (!annotated.isAnnotationPresent(annotation)) continue;
                    result.add(annotated);
                }
                catch (ClassNotFoundException e) {}
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Annotation> classfileAnnotationsFor(AnnotationFinder.Info info) {
            Map map = Finder.this.classfileAnnotations;
            synchronized (map) {
                if (!Finder.this.classfileAnnotations.containsKey(info)) {
                    ArrayList<Annotation> result = new ArrayList<Annotation>();
                    Finder.this.classfileAnnotations.put(info, result);
                    return result;
                }
            }
            return (List)Finder.this.classfileAnnotations.get(info);
        }
    }

    private static class IncludesClassfile<T extends AnnotatedElement>
    implements Annotated<T> {
        private final T target;
        private final Annotation[] annotations;

        IncludesClassfile(T target, List<Annotation> classfileAnnotations) {
            this(target, classfileAnnotations.toArray(new Annotation[classfileAnnotations.size()]));
        }

        IncludesClassfile(T target, Annotation[] classfileAnnotations) {
            this.target = target;
            this.annotations = ArrayUtils.addAll(target.getAnnotations(), classfileAnnotations);
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            for (Annotation prospect : this.annotations) {
                if (!prospect.annotationType().equals(annotationType)) continue;
                Annotation result = prospect;
                return (A)result;
            }
            return null;
        }

        @Override
        public Annotation[] getAnnotations() {
            Annotation[] result = new Annotation[this.annotations.length];
            System.arraycopy(this.annotations, 0, result, 0, this.annotations.length);
            return result;
        }

        @Override
        public Annotation[] getDeclaredAnnotations() {
            return this.getAnnotations();
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation((Class)annotationType) != null;
        }

        @Override
        public T get() {
            return this.target;
        }
    }

    public class Visitor
    extends ClassVisitor {
        private final AnnotationFinder.InfoBuildingVisitor wrapped;

        public Visitor(AnnotationFinder.InfoBuildingVisitor wrapped) {
            super(262144, wrapped);
            this.wrapped = wrapped;
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            FieldVisitor toWrap = this.wrapped.visitField(access, name, desc, signature, value);
            AnnotationFinder.ClassInfo classInfo = (AnnotationFinder.ClassInfo)this.wrapped.getInfo();
            AnnotationFinder.FieldInfo testFieldInfo = null;
            for (int i = classInfo.getFields().size() - 1; i >= 0; --i) {
                AnnotationFinder.FieldInfo atI = classInfo.getFields().get(i);
                if (!atI.getName().equals(name) || !atI.getType().equals(desc)) continue;
                testFieldInfo = atI;
                break;
            }
            if (testFieldInfo == null) {
                return toWrap;
            }
            final AnnotationFinder.FieldInfo fieldInfo = testFieldInfo;
            return new FieldVisitor(262144, toWrap){

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationVisitor toWrap = super.visitAnnotation(desc, visible);
                    return visible ? toWrap : new TopLevelAnnotationInflater(desc, toWrap, fieldInfo);
                }
            };
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor toWrap = this.wrapped.visitMethod(access, name, desc, signature, exceptions);
            AnnotationFinder.ClassInfo classInfo = (AnnotationFinder.ClassInfo)this.wrapped.getInfo();
            AnnotationFinder.MethodInfo compareMethodInfo = new AnnotationFinder.MethodInfo(Finder.this, classInfo, name, desc);
            if (!compareMethodInfo.isConstructor() && !this.isJavaIdentifier(name)) {
                return toWrap;
            }
            AnnotationFinder.MethodInfo testMethodInfo = null;
            try {
                Member member = compareMethodInfo.get();
                for (int i = classInfo.getMethods().size() - 1; i >= 0; --i) {
                    AnnotationFinder.MethodInfo atI = classInfo.getMethods().get(i);
                    if (!atI.getName().equals(name) || !atI.get().equals(member)) continue;
                    testMethodInfo = atI;
                    break;
                }
            }
            catch (ClassNotFoundException e) {
                return toWrap;
            }
            if (testMethodInfo == null) {
                return toWrap;
            }
            final AnnotationFinder.MethodInfo methodInfo = testMethodInfo;
            return new MethodVisitor(262144, toWrap){

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotationVisitor toWrap = super.visitAnnotation(desc, visible);
                    return visible ? toWrap : new TopLevelAnnotationInflater(desc, toWrap, methodInfo);
                }

                @Override
                public AnnotationVisitor visitParameterAnnotation(int param, String desc, boolean visible) {
                    AnnotationVisitor toWrap = super.visitParameterAnnotation(param, desc, visible);
                    if (visible) {
                        return toWrap;
                    }
                    AnnotationFinder.ParameterInfo parameterInfo = null;
                    for (int i = methodInfo.getParameters().size() - 1; i >= 0; --i) {
                        AnnotationFinder.ParameterInfo atI = methodInfo.getParameters().get(i);
                        try {
                            if (atI.get().getIndex() != param) continue;
                            parameterInfo = atI;
                            break;
                        }
                        catch (ClassNotFoundException e) {
                            // empty catch block
                        }
                    }
                    return parameterInfo == null ? toWrap : new TopLevelAnnotationInflater(desc, toWrap, parameterInfo);
                }
            };
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor toWrap = super.visitAnnotation(desc, visible);
            return visible ? toWrap : new TopLevelAnnotationInflater(desc, toWrap, this.wrapped.getInfo());
        }

        private boolean isJavaIdentifier(String toCheck) {
            if (toCheck.isEmpty() || !Character.isJavaIdentifierStart(toCheck.charAt(0))) {
                return false;
            }
            for (char chr : toCheck.substring(1).toCharArray()) {
                if (Character.isJavaIdentifierPart(chr)) continue;
                return false;
            }
            return true;
        }
    }

    private class TopLevelAnnotationInflater
    extends AnnotationInflater {
        private final AnnotationFinder.Info info;

        TopLevelAnnotationInflater(String desc, AnnotationVisitor wrapped, AnnotationFinder.Info info) {
            super(desc, wrapped);
            this.info = info;
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            this.classfileAnnotationsFor(this.info).add(this.inflate());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Annotation> classfileAnnotationsFor(AnnotationFinder.Info info) {
            ThreadLocal threadLocal = CLASSFILE_ANNOTATIONS;
            synchronized (threadLocal) {
                if (!((Map)CLASSFILE_ANNOTATIONS.get()).containsKey(info)) {
                    ArrayList<Annotation> result = new ArrayList<Annotation>();
                    ((Map)CLASSFILE_ANNOTATIONS.get()).put(info, result);
                    return result;
                }
            }
            return (List)((Map)CLASSFILE_ANNOTATIONS.get()).get(info);
        }
    }

    private abstract class AnnotationCapturer
    extends AnnotationVisitor {
        public AnnotationCapturer(AnnotationVisitor wrapped) {
            super(262144, wrapped);
        }

        protected abstract void storeValue(String var1, Object var2);

        @Override
        public void visit(String name, Object value) {
            this.storeValue(name, value);
        }

        @Override
        public AnnotationVisitor visitAnnotation(final String name, String desc) {
            final AnnotationCapturer owner = this;
            return new AnnotationInflater(desc, super.visitAnnotation(name, desc)){

                @Override
                public void visitEnd() {
                    owner.storeValue(name, this.inflate());
                }
            };
        }

        @Override
        public AnnotationVisitor visitArray(final String name) {
            final AnnotationCapturer owner = this;
            final ArrayList values = new ArrayList();
            return new AnnotationCapturer(super.visitArray(name)){

                @Override
                public void visitEnd() {
                    owner.storeValue(name, values.toArray());
                    super.visitEnd();
                }

                @Override
                protected void storeValue(String name2, Object value) {
                    values.add(value);
                }
            };
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            Class<Enum> enumType;
            super.visitEnum(name, desc, value);
            try {
                enumType = Class.forName(Type.getType(desc).getClassName()).asSubclass(Enum.class);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            Enum enumValue = Enum.valueOf(enumType, value);
            this.storeValue(name, enumValue);
        }
    }

    private abstract class AnnotationInflater
    extends AnnotationCapturer {
        final Class<? extends Annotation> annotationType;
        final Map<String, Object> elements;

        AnnotationInflater(String desc, AnnotationVisitor wrapped) {
            super(wrapped);
            this.elements = new LinkedHashMap<String, Object>();
            this.annotationType = Finder.this.toClass(Type.getType(desc)).asSubclass(Annotation.class);
        }

        Annotation inflate() {
            return Annotations.instanceOf(this.annotationType, this.elements);
        }

        @Override
        protected void storeValue(String name, Object value) {
            Object toStore = value;
            Validate.notNull(toStore, "null annotation element", new Object[0]);
            if (toStore.getClass().isArray()) {
                Class<?> requiredType;
                try {
                    requiredType = this.annotationType.getDeclaredMethod(name, new Class[0]).getReturnType();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (!requiredType.isInstance(toStore)) {
                    int len = Array.getLength(toStore);
                    Object typedArray = Array.newInstance(requiredType.getComponentType(), len);
                    for (int i = 0; i < len; ++i) {
                        Object element = Array.get(toStore, i);
                        if (element instanceof Type) {
                            element = Finder.this.toClass((Type)element);
                        }
                        Array.set(typedArray, i, element);
                    }
                    toStore = typedArray;
                }
            } else if (toStore instanceof Type) {
                toStore = Finder.this.toClass((Type)toStore);
            }
            this.elements.put(name, toStore);
        }
    }
}

