/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.maven;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.commons.weaver.WeaveProcessor;
import org.apache.commons.weaver.maven.JavaLoggingToMojoLoggingRedirector;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractWeaveMojo
extends AbstractMojo {
    @Parameter(defaultValue="false")
    protected boolean verbose;
    @Parameter(property="weaver.config", required=false)
    protected Properties weaverConfig;

    protected abstract List<String> getClasspath();

    protected abstract File getTarget();

    public void execute() throws MojoExecutionException {
        JavaLoggingToMojoLoggingRedirector logRedirector = new JavaLoggingToMojoLoggingRedirector(this.getLog());
        logRedirector.activate();
        List<String> classpath = this.getClasspath();
        File target = this.getTarget();
        Properties config = this.weaverConfig == null ? new Properties() : this.weaverConfig;
        this.getLog().debug((CharSequence)String.format("classpath=%s%ntarget=%s%nconfig=%s", classpath, target, config));
        try {
            WeaveProcessor weaveProcessor = new WeaveProcessor(classpath, target, config);
            weaveProcessor.weave();
        }
        catch (Exception e) {
            throw new MojoExecutionException("weaving failed due to " + e.getMessage(), e);
        }
        finally {
            logRedirector.deactivate();
        }
    }
}

