/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.normalizer;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.weaver.normalizer._lang3.ClassUtils;
import org.apache.commons.weaver.normalizer._lang3.StringUtils;
import org.apache.commons.weaver.normalizer._lang3.Validate;

final class Utils {
    private Utils() {
    }

    static String validatePackageName(String pkg) {
        int last;
        if (StringUtils.isBlank(pkg)) {
            return "";
        }
        String result = pkg.trim();
        String unexpected = "Unexpected character %s at pos %s of package name \"%s\"";
        boolean next = true;
        for (int pos = 0; pos < result.length(); ++pos) {
            char chr = result.charAt(pos);
            if (next) {
                next = false;
                Validate.isTrue(Character.isJavaIdentifierStart(chr), "Unexpected character %s at pos %s of package name \"%s\"", Character.valueOf(chr), pos, result);
                continue;
            }
            if (chr == '/' || chr == '.') {
                next = true;
                continue;
            }
            Validate.isTrue(Character.isJavaIdentifierPart(chr), "Unexpected character %s at pos %s of package name \"%s\"", Character.valueOf(chr), pos, result);
        }
        if ((result = result.replace('.', '/')).charAt(last = result.length() - 1) == '/') {
            result = result.substring(0, last);
        }
        return result;
    }

    static Set<Class<?>> parseTypes(String types, ClassLoader classLoader) {
        LinkedHashSet result = new LinkedHashSet();
        for (String token : StringUtils.splitByWholeSeparatorPreserveAllTokens(types, ",")) {
            try {
                result.add(ClassUtils.getClass(classLoader, token.trim().replace('/', '.')));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result;
    }
}

