/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.ant;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.weaver.ant.InlineProperties;
import org.apache.commons.weaver.ant._lang3.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PropertySet;
import org.apache.tools.ant.types.Reference;

public class WeaverSettings
extends DataType {
    private File target;
    private Path classpath;
    private String classpathref;
    private PropertySet propertySet;
    private InlineProperties inlineProperties;

    public WeaverSettings(Project project) {
        this.setProject(project);
    }

    public File getTarget() {
        if (this.isReference()) {
            return this.getRef().getTarget();
        }
        return this.target;
    }

    public void setTarget(File target) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.target = target;
    }

    public String getClasspathref() {
        if (this.isReference()) {
            return this.getRef().getClasspathref();
        }
        return this.classpathref;
    }

    public void setClasspathRef(String classpathref) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.classpathref = classpathref;
    }

    public List<String> getClasspathEntries() {
        Path path = new Path(this.getProject());
        Path classpath = this.getClasspath();
        if (classpath != null) {
            path.add(classpath);
        }
        path.add(Path.systemClasspath);
        return Arrays.asList(path.list());
    }

    public Path getClasspath() {
        if (this.isReference()) {
            return this.getRef().getClasspath();
        }
        if (this.classpath == null) {
            if (this.getClasspathref() != null) {
                Path ref = new Path(this.getProject());
                ref.setRefid(new Reference(this.getProject(), this.getClasspathref()));
                return ref;
            }
        } else if (StringUtils.isNotBlank(this.getClasspathref())) {
            throw new BuildException("Only one of classpathref|classpath is permitted.");
        }
        return this.classpath;
    }

    public void setClasspath(Path classpath) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (this.classpath != null) {
            throw new BuildException("classpath already set");
        }
        this.classpath = classpath;
    }

    public InlineProperties createProperties() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.inlineProperties != null) {
            throw new BuildException("properties already specified");
        }
        this.inlineProperties = new InlineProperties();
        return this.inlineProperties;
    }

    public PropertySet createPropertySet() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        if (this.propertySet != null) {
            throw new BuildException("propertyset already specified");
        }
        this.propertySet = new PropertySet();
        this.propertySet.setProject(this.getProject());
        return this.propertySet;
    }

    public Properties getProperties() {
        if (this.isReference()) {
            return this.getRef().getProperties();
        }
        if (this.propertySet == null && this.inlineProperties == null) {
            this.createPropertySet().appendBuiltin((PropertySet.BuiltinPropertySetName)EnumeratedAttribute.getInstance(PropertySet.BuiltinPropertySetName.class, "all"));
        }
        Properties result = new Properties();
        if (this.propertySet != null) {
            result.putAll((Map<?, ?>)this.propertySet.getProperties());
        }
        if (this.inlineProperties != null) {
            for (Map.Entry<Object, Object> entry : this.inlineProperties.properties.entrySet()) {
                result.put(entry.getKey(), StringUtils.trim((String)entry.getValue()));
            }
        }
        return result;
    }

    private WeaverSettings getRef() {
        return this.getCheckedRef(WeaverSettings.class, "settings");
    }
}

