/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.ant._xbean.finder.archive;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.weaver.ant._xbean.finder.archive.Archive;
import org.apache.commons.weaver.ant._xbean.finder.archive.ArchiveIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileArchive
implements Archive {
    private final ClassLoader loader;
    private final String basePackage;
    private final File dir;
    private List<String> list;

    public FileArchive(ClassLoader loader, URL url) {
        this.loader = loader;
        this.basePackage = "";
        this.dir = FileArchive.toFile(url);
    }

    public FileArchive(ClassLoader loader, File dir) {
        this.loader = loader;
        this.basePackage = "";
        this.dir = dir;
    }

    public FileArchive(ClassLoader loader, URL url, String basePackage) {
        this.loader = loader;
        this.basePackage = basePackage;
        this.dir = FileArchive.toFile(url);
    }

    public FileArchive(ClassLoader loader, File dir, String basePackage) {
        this.loader = loader;
        this.basePackage = basePackage;
        this.dir = dir;
    }

    public File getDir() {
        return this.dir;
    }

    @Override
    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        URL resource;
        int pos = className.indexOf("<");
        if (pos > -1) {
            className = className.substring(0, pos);
        }
        if ((pos = className.indexOf(">")) > -1) {
            className = className.substring(0, pos);
        }
        if (!className.endsWith(".class")) {
            className = className.replace('.', '/') + ".class";
        }
        if ((resource = this.loader.getResource(className)) != null) {
            return new BufferedInputStream(resource.openStream());
        }
        throw new ClassNotFoundException(className);
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loader.loadClass(className);
    }

    @Override
    public Iterator<Archive.Entry> iterator() {
        return new ArchiveIterator(this, this._iterator());
    }

    public Iterator<String> _iterator() {
        if (this.list != null) {
            return this.list.iterator();
        }
        this.list = this.file(this.dir);
        return this.list.iterator();
    }

    private List<String> file(File dir) {
        ArrayList<String> classNames = new ArrayList<String>();
        if (dir.isDirectory()) {
            this.scanDir(dir, classNames, this.basePackage.length() > 0 ? this.basePackage + "." : this.basePackage);
        }
        return classNames;
    }

    private void scanDir(File dir, List<String> classNames, String packageName) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.scanDir(file, classNames, packageName + file.getName() + ".");
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String name = file.getName();
            if ((name = name.replaceFirst(".class$", "")).contains(".")) continue;
            classNames.add(packageName + name);
        }
    }

    private static File toFile(URL url) {
        if (!"file".equals(url.getProtocol())) {
            throw new IllegalArgumentException("not a file url: " + url);
        }
        String path = url.getFile();
        File dir = new File(FileArchive.decode(path));
        if (dir.getName().equals("META-INF")) {
            dir = dir.getParentFile();
        }
        return dir;
    }

    public static String decode(String fileName) {
        if (fileName.indexOf(37) == -1) {
            return fileName;
        }
        StringBuilder result = new StringBuilder(fileName.length());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = 0;
        while (i < fileName.length()) {
            char c = fileName.charAt(i);
            if (c == '%') {
                out.reset();
                do {
                    if (i + 2 >= fileName.length()) {
                        throw new IllegalArgumentException("Incomplete % sequence at: " + i);
                    }
                    int d1 = Character.digit(fileName.charAt(i + 1), 16);
                    int d2 = Character.digit(fileName.charAt(i + 2), 16);
                    if (d1 == -1 || d2 == -1) {
                        throw new IllegalArgumentException("Invalid % sequence (" + fileName.substring(i, i + 3) + ") at: " + String.valueOf(i));
                    }
                    out.write((byte)((d1 << 4) + d2));
                } while ((i += 3) < fileName.length() && fileName.charAt(i) == '%');
                result.append(out.toString());
                continue;
            }
            result.append(c);
            ++i;
        }
        return result.toString();
    }
}

