/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.privilizer;

import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.weaver.privilizer.FieldAccess;
import org.apache.commons.weaver.privilizer.Privileged;
import org.apache.commons.weaver.privilizer.Privilizer;
import org.apache.commons.weaver.privilizer.Privilizing;
import org.apache.commons.weaver.privilizer._asm.ClassReader;
import org.apache.commons.weaver.privilizer._asm.ClassVisitor;
import org.apache.commons.weaver.privilizer._asm.FieldVisitor;
import org.apache.commons.weaver.privilizer._asm.Label;
import org.apache.commons.weaver.privilizer._asm.MethodVisitor;
import org.apache.commons.weaver.privilizer._asm.Type;
import org.apache.commons.weaver.privilizer._asm.commons.AdviceAdapter;
import org.apache.commons.weaver.privilizer._asm.commons.Method;
import org.apache.commons.weaver.privilizer._asm.tree.ClassNode;
import org.apache.commons.weaver.privilizer._asm.tree.MethodNode;
import org.apache.commons.weaver.privilizer._io.IOUtils;
import org.apache.commons.weaver.privilizer._lang3.ArrayUtils;
import org.apache.commons.weaver.privilizer._lang3.Validate;
import org.apache.commons.weaver.privilizer._lang3.mutable.MutableObject;
import org.apache.commons.weaver.privilizer._lang3.tuple.Pair;

class BlueprintingVisitor
extends Privilizer.PrivilizerClassVisitor {
    private final Set<Type> blueprintTypes;
    private final Map<Pair<Type, Method>, MethodNode> blueprintRegistry;
    private final Map<Pair<Type, Method>, String> importedMethods;
    private final Map<Type, Map<Method, MethodNode>> methodCache;
    private final Map<Pair<Type, String>, FieldAccess> fieldAccessMap;
    private final ClassVisitor next;

    BlueprintingVisitor(Privilizer privilizer, ClassVisitor cv, Privilizing config) {
        Privilizer privilizer2 = privilizer;
        privilizer2.getClass();
        super(privilizer2, (ClassVisitor)new ClassNode(327680));
        this.blueprintTypes = new HashSet<Type>();
        this.blueprintRegistry = new HashMap<Pair<Type, Method>, MethodNode>();
        this.importedMethods = new HashMap<Pair<Type, Method>, String>();
        this.methodCache = new HashMap<Type, Map<Method, MethodNode>>();
        this.fieldAccessMap = new HashMap<Pair<Type, String>, FieldAccess>();
        this.next = cv;
        for (Privilizing.CallTo callTo : config.value()) {
            Type blueprintType = Type.getType(callTo.value());
            this.blueprintTypes.add(blueprintType);
            for (Map.Entry<Method, MethodNode> entry : this.getMethods(blueprintType).entrySet()) {
                boolean found = false;
                if (callTo.methods().length == 0) {
                    found = true;
                } else {
                    for (String name : callTo.methods()) {
                        if (!entry.getKey().getName().equals(name)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) continue;
                this.blueprintRegistry.put(Pair.of(blueprintType, entry.getKey()), entry.getValue());
            }
        }
    }

    private Map<Method, MethodNode> getMethods(Type type) {
        if (this.methodCache.containsKey(type)) {
            return this.methodCache.get(type);
        }
        ClassNode classNode = this.read(type.getClassName());
        HashMap<Method, MethodNode> result = new HashMap<Method, MethodNode>();
        List methods = classNode.methods;
        for (MethodNode methodNode : methods) {
            if (!Modifier.isStatic(methodNode.access) || "<clinit>".equals(methodNode.name)) continue;
            result.put(new Method(methodNode.name, methodNode.desc), methodNode);
        }
        this.methodCache.put(type, result);
        return result;
    }

    private ClassNode read(String className) {
        ClassNode result = new ClassNode(327680);
        InputStream bytecode = null;
        try {
            bytecode = this.privilizer().env.getClassfile(className).getInputStream();
            new ClassReader(bytecode).accept(result, 10);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bytecode);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bytecode);
        return result;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        Validate.isTrue(!this.blueprintTypes.contains(Type.getObjectType(name)), "Class %s cannot declare itself as a blueprint!", name);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor toWrap = super.visitMethod(access, name, desc, signature, exceptions);
        return new MethodInvocationHandler(toWrap){

            @Override
            boolean shouldImport(Pair<Type, Method> methodKey) {
                return BlueprintingVisitor.this.blueprintRegistry.containsKey(methodKey);
            }
        };
    }

    private String importMethod(Pair<Type, Method> key) {
        if (this.importedMethods.containsKey(key)) {
            return this.importedMethods.get(key);
        }
        String result = key.getLeft().getInternalName().replace('/', '_') + "$$" + key.getRight().getName();
        this.importedMethods.put(key, result);
        this.privilizer().env.debug("importing %s#%s as %s", new Object[]{key.getLeft().getClassName(), key.getRight(), result});
        int access = 4106;
        MethodNode source = this.getMethods(key.getLeft()).get(key.getRight());
        String[] exceptions = source.exceptions.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        final LinkedHashSet fieldAccesses = new LinkedHashSet();
        source.accept(new MethodVisitor(327680){

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                FieldAccess fieldAccess = BlueprintingVisitor.this.fieldAccess(Type.getObjectType(owner), name);
                super.visitFieldInsn(opcode, owner, name, desc);
                if (!Modifier.isPublic(fieldAccess.access)) {
                    fieldAccesses.add(fieldAccess);
                }
            }
        });
        MethodNode withAccessibleAdvice = new MethodNode(4106, result, source.desc, source.signature, exceptions);
        MethodVisitor mv = new NestedMethodInvocationHandler(withAccessibleAdvice, key.getLeft());
        if (!fieldAccesses.isEmpty()) {
            mv = new AccessibleAdvisor(mv, 4106, result, source.desc, new ArrayList<FieldAccess>(fieldAccesses));
        }
        source.accept(mv);
        if (!Modifier.isPrivate(source.access)) {
            withAccessibleAdvice.visitAnnotation(Type.getType(Privileged.class).getDescriptor(), false).visitEnd();
        }
        withAccessibleAdvice.accept(this.cv);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FieldAccess fieldAccess(Type owner, String name) {
        Pair<Type, String> key;
        block6: {
            key = Pair.of(owner, name);
            if (this.fieldAccessMap.containsKey(key)) break block6;
            try {
                final MutableObject<Type> next = new MutableObject<Type>(owner);
                final ArrayDeque<Type> stk = new ArrayDeque<Type>();
                while (next.getValue() != null) {
                    stk.push(next.getValue());
                    InputStream bytecode = null;
                    try {
                        bytecode = this.privilizer().env.getClassfile(next.getValue().getInternalName()).getInputStream();
                        ClassReader classReader = new ClassReader(bytecode);
                        Privilizer privilizer = this.privilizer();
                        privilizer.getClass();
                        classReader.accept(new Privilizer.PrivilizerClassVisitor(privilizer){

                            @Override
                            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                                super.visit(version, access, name, signature, superName, interfaces);
                                next.setValue(Type.getObjectType(superName));
                            }

                            @Override
                            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                                for (Type type : stk) {
                                    Pair<Type, String> key = Pair.of(type, name);
                                    if (BlueprintingVisitor.this.fieldAccessMap.containsKey(key)) continue;
                                    BlueprintingVisitor.this.fieldAccessMap.put(key, new FieldAccess(access, this.target, name, Type.getType(desc)));
                                }
                                return null;
                            }
                        }, 1);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(bytecode);
                        throw throwable;
                    }
                    IOUtils.closeQuietly(bytecode);
                    if (!this.fieldAccessMap.containsKey(key)) continue;
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Validate.isTrue(this.fieldAccessMap.containsKey(key), "Could not locate %s.%s", owner.getClassName(), name);
        }
        return this.fieldAccessMap.get(key);
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        ((ClassNode)this.cv).accept(this.next);
    }

    private class AccessibleAdvisor
    extends AdviceAdapter {
        final Type bitSetType;
        final Type classType;
        final Type fieldType;
        final Type fieldArrayType;
        final Type stringType;
        final List<FieldAccess> fieldAccesses;
        final Label begin;
        int localFieldArray;
        int bitSet;
        int fieldCounter;

        AccessibleAdvisor(MethodVisitor mvr, int access, String name, String desc, List<FieldAccess> fieldAccesses) {
            super(327680, mvr, access, name, desc);
            this.bitSetType = Type.getType(BitSet.class);
            this.classType = Type.getType(Class.class);
            this.fieldType = Type.getType(Field.class);
            this.fieldArrayType = Type.getType(Field[].class);
            this.stringType = Type.getType(String.class);
            this.begin = new Label();
            this.fieldAccesses = fieldAccesses;
        }

        @Override
        protected void onMethodEnter() {
            this.localFieldArray = this.newLocal(this.fieldArrayType);
            this.bitSet = this.newLocal(this.bitSetType);
            this.fieldCounter = this.newLocal(Type.INT_TYPE);
            this.push(this.fieldAccesses.size());
            this.newArray(this.fieldArrayType.getElementType());
            this.storeLocal(this.localFieldArray);
            this.newInstance(this.bitSetType);
            this.dup();
            this.push(this.fieldAccesses.size());
            this.invokeConstructor(this.bitSetType, Method.getMethod("void <init>(int)"));
            this.storeLocal(this.bitSet);
            this.push(0);
            this.storeLocal(this.fieldCounter);
            for (FieldAccess access : this.fieldAccesses) {
                this.prehandle(access);
                this.iinc(this.fieldCounter, 1);
            }
            this.mark(this.begin);
        }

        private void prehandle(FieldAccess access) {
            this.visitLdcInsn(access.owner);
            this.push(access.name);
            Label next = new Label();
            this.invokeVirtual(this.classType, new Method("getDeclaredField", this.fieldType, new Type[]{this.stringType}));
            this.dup();
            this.loadLocal(this.localFieldArray);
            this.swap();
            this.loadLocal(this.fieldCounter);
            this.swap();
            this.arrayStore(this.fieldArrayType.getElementType());
            this.dup();
            this.invokeVirtual(this.fieldArrayType.getElementType(), Method.getMethod("boolean isAccessible()"));
            Label setAccessible = new Label();
            this.ifZCmp(153, setAccessible);
            this.pop();
            this.loadLocal(this.bitSet);
            this.loadLocal(this.fieldCounter);
            this.invokeVirtual(this.bitSetType, Method.getMethod("void set(int)"));
            this.goTo(next);
            this.mark(setAccessible);
            this.push(true);
            this.invokeVirtual(this.fieldArrayType.getElementType(), Method.getMethod("void setAccessible(boolean)"));
            this.mark(next);
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            Method access;
            Pair<Type, String> key = Pair.of(Type.getObjectType(owner), name);
            FieldAccess fieldAccess = (FieldAccess)BlueprintingVisitor.this.fieldAccessMap.get(key);
            Validate.isTrue(this.fieldAccesses.contains(fieldAccess), "Cannot find field %s", key);
            int fieldIndex = this.fieldAccesses.indexOf(fieldAccess);
            this.visitInsn(0);
            this.loadLocal(this.localFieldArray);
            this.push(fieldIndex);
            this.arrayLoad(this.fieldArrayType.getElementType());
            this.checkCast(this.fieldType);
            if (opcode == 179) {
                this.swap();
                this.push((String)null);
                this.swap();
                if (fieldAccess.type.getSort() < 9) {
                    this.valueOf(fieldAccess.type);
                }
                access = Method.getMethod("void set(Object, Object)");
            } else {
                access = Method.getMethod("Object get(Object)");
                this.push((String)null);
            }
            this.invokeVirtual(this.fieldType, access);
            if (opcode == 178) {
                this.checkCast(BlueprintingVisitor.this.privilizer().wrap(fieldAccess.type));
                if (fieldAccess.type.getSort() < 9) {
                    this.unbox(fieldAccess.type);
                }
            }
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            Label fny = this.mark();
            Type exceptionType = null;
            this.catchException(this.begin, fny, exceptionType);
            this.onFinally();
            this.throwException();
            super.visitMaxs(maxStack, maxLocals);
        }

        @Override
        protected void onMethodExit(int opcode) {
            if (opcode != 191) {
                this.onFinally();
            }
        }

        private void onFinally() {
            this.push(0);
            this.storeLocal(this.fieldCounter);
            Label test = this.mark();
            Label increment = new Label();
            Label endFinally = new Label();
            this.loadLocal(this.fieldCounter);
            this.push(this.fieldAccesses.size());
            this.ifCmp(Type.INT_TYPE, 156, endFinally);
            this.loadLocal(this.bitSet);
            this.loadLocal(this.fieldCounter);
            this.invokeVirtual(this.bitSetType, Method.getMethod("boolean get(int)"));
            this.ifZCmp(154, increment);
            this.loadLocal(this.localFieldArray);
            this.loadLocal(this.fieldCounter);
            this.arrayLoad(this.fieldArrayType.getElementType());
            this.push(false);
            this.invokeVirtual(this.fieldArrayType.getElementType(), Method.getMethod("void setAccessible(boolean)"));
            this.mark(increment);
            this.iinc(this.fieldCounter, 1);
            this.goTo(test);
            this.mark(endFinally);
        }
    }

    class NestedMethodInvocationHandler
    extends MethodInvocationHandler {
        final Type owner;

        NestedMethodInvocationHandler(MethodVisitor mvr, Type owner) {
            super(mvr);
            this.owner = owner;
        }

        @Override
        boolean shouldImport(Pair<Type, Method> methodKey) {
            Type called = methodKey.getLeft();
            if (called.equals(this.owner)) {
                return true;
            }
            try {
                Class<?> inner = this.load(called);
                Class<?> outer = this.load(this.owner);
                return inner.isAssignableFrom(outer);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        private Class<?> load(Type type) throws ClassNotFoundException {
            return BlueprintingVisitor.this.privilizer().env.classLoader.loadClass(type.getClassName());
        }
    }

    private abstract class MethodInvocationHandler
    extends MethodVisitor {
        MethodInvocationHandler(MethodVisitor mvr) {
            super(327680, mvr);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (opcode == 184) {
                Method methd = new Method(name, desc);
                Pair<Type, Method> methodKey = Pair.of(Type.getObjectType(owner), methd);
                if (this.shouldImport(methodKey)) {
                    String importedName = BlueprintingVisitor.this.importMethod(methodKey);
                    super.visitMethodInsn(opcode, BlueprintingVisitor.this.className, importedName, desc, itf);
                    return;
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }

        abstract boolean shouldImport(Pair<Type, Method> var1);
    }
}

