/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.maven;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;

public class JavaLoggingToMojoLoggingRedirector {
    private final List<Handler> removedHandlers = new ArrayList<Handler>();
    private final Log mojoLogger;
    private JDKLogHandler activeHandler;

    public JavaLoggingToMojoLoggingRedirector(Log mojoLogger) {
        this.mojoLogger = mojoLogger;
    }

    public void activate() throws MojoExecutionException {
        try {
            Logger rootLogger = LogManager.getLogManager().getLogger("");
            for (Handler handler : rootLogger.getHandlers()) {
                rootLogger.removeHandler(handler);
                this.removedHandlers.add(handler);
            }
            if (this.removedHandlers.isEmpty()) {
                throw new MojoExecutionException("could not remove any handler. aborting.");
            }
            this.activeHandler = new JDKLogHandler();
            this.activeHandler.setLevel(Level.ALL);
            rootLogger.setLevel(Level.ALL);
            rootLogger.addHandler(this.activeHandler);
        }
        catch (Exception exc) {
            throw new MojoExecutionException("failed to activate the jul logging redirector", exc);
        }
    }

    public void deactivate() {
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        for (Handler handler : rootLogger.getHandlers()) {
            if (handler != this.activeHandler) continue;
            rootLogger.removeHandler(handler);
        }
        for (Handler oldHandler : this.removedHandlers) {
            rootLogger.addHandler(oldHandler);
        }
    }

    private class JDKLogHandler
    extends Handler {
        private JDKLogHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            Throwable exception = record.getThrown();
            Level level = record.getLevel();
            if (level == Level.SEVERE && JavaLoggingToMojoLoggingRedirector.this.mojoLogger.isErrorEnabled()) {
                if (exception == null) {
                    JavaLoggingToMojoLoggingRedirector.this.mojoLogger.error((CharSequence)this.getMessage(record));
                } else {
                    JavaLoggingToMojoLoggingRedirector.this.mojoLogger.error((CharSequence)this.getMessage(record), exception);
                }
            } else if (level == Level.WARNING && JavaLoggingToMojoLoggingRedirector.this.mojoLogger.isWarnEnabled()) {
                if (exception == null) {
                    JavaLoggingToMojoLoggingRedirector.this.mojoLogger.warn((CharSequence)this.getMessage(record));
                } else {
                    JavaLoggingToMojoLoggingRedirector.this.mojoLogger.warn((CharSequence)this.getMessage(record), exception);
                }
            } else if (level == Level.INFO && JavaLoggingToMojoLoggingRedirector.this.mojoLogger.isInfoEnabled()) {
                if (exception == null) {
                    JavaLoggingToMojoLoggingRedirector.this.mojoLogger.info((CharSequence)this.getMessage(record));
                } else {
                    JavaLoggingToMojoLoggingRedirector.this.mojoLogger.info((CharSequence)this.getMessage(record), exception);
                }
            } else if (JavaLoggingToMojoLoggingRedirector.this.mojoLogger.isDebugEnabled()) {
                if (exception == null) {
                    JavaLoggingToMojoLoggingRedirector.this.mojoLogger.debug((CharSequence)this.getMessage(record));
                } else {
                    JavaLoggingToMojoLoggingRedirector.this.mojoLogger.debug((CharSequence)this.getMessage(record), exception);
                }
            }
        }

        private String getMessage(LogRecord record) {
            ResourceBundle bundle = record.getResourceBundle();
            Object[] params = record.getParameters();
            String message = bundle != null && bundle.containsKey(record.getMessage()) ? bundle.getString(record.getMessage()) : record.getMessage();
            if (ArrayUtils.isNotEmpty((Object[])params)) {
                return new MessageFormat(message).format(params);
            }
            return message;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

