/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import org.apache.commons.weaver.ant._lang3.Validate;
import org.apache.commons.weaver.spi.WeaveLifecycleProvider;
import org.apache.commons.weaver.utils.Providers;

class ProcessorBase<P extends WeaveLifecycleProvider<?>> {
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    protected final List<String> classpath;
    protected final File target;
    protected final Properties configuration;
    protected final Iterable<P> providers;

    static <T> Iterable<T> getServiceInstances(Class<T> type) {
        Validate.notNull(type);
        ArrayList<T> result = new ArrayList<T>();
        ClassLoader typeLoader = type.getClassLoader();
        if (!Thread.currentThread().getContextClassLoader().equals(typeLoader)) {
            for (T t : ServiceLoader.load(type, typeLoader)) {
                result.add(t);
            }
        }
        for (T t : ServiceLoader.load(type)) {
            result.add(t);
        }
        return Collections.unmodifiableList(result);
    }

    protected ProcessorBase(List<String> classpath, File target, Properties configuration, Iterable<P> providers) {
        this.classpath = Validate.notNull(classpath, "classpath", new Object[0]);
        this.target = Validate.notNull(target, "target", new Object[0]);
        Validate.isTrue(!target.exists() || target.isDirectory(), "%s is not a directory", target);
        this.configuration = Validate.notNull(configuration, "configuration", new Object[0]);
        this.providers = Providers.sort(providers);
    }
}

