/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver;

import java.io.File;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.weaver.Finder;
import org.apache.commons.weaver.LocalWeaveEnvironment;
import org.apache.commons.weaver.ProcessorBase;
import org.apache.commons.weaver.ant._xbean.finder.archive.FileArchive;
import org.apache.commons.weaver.spi.Weaver;
import org.apache.commons.weaver.utils.URLArray;

public class WeaveProcessor
extends ProcessorBase<Weaver> {
    public WeaveProcessor(List<String> classpath, File target, Properties configuration) {
        super(classpath, target, configuration, WeaveProcessor.getServiceInstances(Weaver.class));
    }

    public WeaveProcessor(List<String> classpath, File target, Properties configuration, Iterable<Weaver> providers) {
        super(classpath, target, configuration, providers);
    }

    public void weave() {
        if (!this.target.exists()) {
            this.log.warning("Target directory " + this.target + " does not exist; nothing to do!");
        }
        LinkedHashSet<String> finderClasspath = new LinkedHashSet<String>();
        finderClasspath.add(this.target.getAbsolutePath());
        finderClasspath.addAll(this.classpath);
        URLClassLoader classLoader = new URLClassLoader(URLArray.fromPaths(finderClasspath));
        Finder finder = new Finder(new FileArchive((ClassLoader)classLoader, this.target));
        for (Weaver weaver : this.providers) {
            LocalWeaveEnvironment env = new LocalWeaveEnvironment(this.target, classLoader, this.configuration, Logger.getLogger(weaver.getClass().getName()));
            weaver.process(env, finder);
        }
    }
}

