/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver;

import java.io.File;
import java.net.URLClassLoader;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.weaver.Finder;
import org.apache.commons.weaver.LocalWeaveEnvironment;
import org.apache.commons.weaver.ProcessorBase;
import org.apache.commons.weaver.spi.Cleaner;
import org.apache.commons.weaver.utils.URLArray;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.FileArchive;

public class CleanProcessor
extends ProcessorBase<Cleaner> {
    public CleanProcessor(List<String> classpath, File target, Properties configuration) {
        this(classpath, target, configuration, CleanProcessor.getServiceInstances(Cleaner.class));
    }

    public CleanProcessor(List<String> classpath, File target, Properties configuration, Iterable<Cleaner> providers) {
        super(classpath, target, configuration, providers);
    }

    public void clean() {
        if (!this.target.exists()) {
            this.log.warning("Target directory " + this.target + " does not exist; nothing to do!");
        }
        LinkedHashSet<String> finderClasspath = new LinkedHashSet<String>();
        finderClasspath.add(this.target.getAbsolutePath());
        finderClasspath.addAll(this.classpath);
        URLClassLoader classLoader = new URLClassLoader(URLArray.fromPaths(finderClasspath));
        Finder finder = new Finder((Archive)new FileArchive((ClassLoader)classLoader, this.target));
        for (Cleaner cleaner : this.providers) {
            LocalWeaveEnvironment env = new LocalWeaveEnvironment(this.target, classLoader, this.configuration, Logger.getLogger(cleaner.getClass().getName()));
            cleaner.clean(env, finder);
        }
    }
}

