/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.activation.DataSource;
import org.apache.commons.weaver.ant._lang3.Validate;

public abstract class WeaveEnvironment {
    private static final String CONTENT_TYPE = "application/octet-stream";
    public final ClassLoader classLoader;
    public final Properties config;
    private final Logger log;

    protected WeaveEnvironment(ClassLoader classLoader, Properties config, Logger log) {
        this.classLoader = classLoader;
        this.config = (Properties)Validate.notNull(config, "config", new Object[0]).clone();
        this.log = log;
    }

    public void debug(String message, Object ... args) {
        this.log.fine(String.format(message, args));
    }

    public void verbose(String message, Object ... args) {
        this.log.fine(String.format(message, args));
    }

    public void warn(String message, Object ... args) {
        this.log.warning(String.format(message, args));
    }

    public void info(String message, Object ... args) {
        this.log.info(String.format(message, args));
    }

    public void error(String message, Object ... args) {
        this.log.severe(String.format(message, args));
    }

    public final DataSource getClassfile(Class<?> cls) {
        return this.getClassfile(cls.getName());
    }

    public final DataSource getClassfile(String classname) {
        return this.getResource(WeaveEnvironment.getResourceName(classname));
    }

    public final DataSource getResource(String name) {
        return new Resource(name);
    }

    public final boolean deleteClassfile(Class<?> cls) {
        return this.deleteClassfile(cls.getName());
    }

    public final boolean deleteClassfile(String classname) {
        return this.deleteResource(WeaveEnvironment.getResourceName(classname));
    }

    public abstract boolean deleteResource(String var1);

    protected abstract OutputStream getOutputStream(String var1) throws IOException;

    protected static String getResourceName(String classname) {
        return classname.replace('.', '/') + ".class";
    }

    private class Resource
    implements DataSource {
        private final String name;

        Resource(String name) {
            this.name = name;
        }

        public String getContentType() {
            return WeaveEnvironment.CONTENT_TYPE;
        }

        public InputStream getInputStream() throws IOException {
            return WeaveEnvironment.this.classLoader.getResourceAsStream(this.name);
        }

        public String getName() {
            return this.name;
        }

        public OutputStream getOutputStream() throws IOException {
            return WeaveEnvironment.this.getOutputStream(this.name);
        }
    }
}

