/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.apache.commons.weaver.LocalWeaveEnvironment;
import org.apache.commons.weaver.ProcessorBase;
import org.apache.commons.weaver.spi.Cleaner;

public class CleanProcessor
extends ProcessorBase<Cleaner> {
    public CleanProcessor(List<String> classpath, File target, Properties configuration) {
        this(classpath, target, configuration, CleanProcessor.getServiceInstances(Cleaner.class));
    }

    public CleanProcessor(List<String> classpath, File target, Properties configuration, Iterable<Cleaner> providers) {
        super(classpath, target, configuration, providers);
    }

    public void clean() {
        if (!this.target.exists()) {
            this.log.warning("Target directory " + this.target + " does not exist; nothing to do!");
        }
        for (Cleaner cleaner : this.providers) {
            LocalWeaveEnvironment env = new LocalWeaveEnvironment(this.target, this.classLoader, this.configuration, Logger.getLogger(cleaner.getClass().getName()));
            cleaner.clean(env, this.finder);
        }
    }
}

