/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.normalizer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.activation.DataSource;
import org.apache.commons.weaver.model.ScanRequest;
import org.apache.commons.weaver.model.ScanResult;
import org.apache.commons.weaver.model.Scanner;
import org.apache.commons.weaver.model.WeavableClass;
import org.apache.commons.weaver.model.WeaveEnvironment;
import org.apache.commons.weaver.normalizer.Utils;
import org.apache.commons.weaver.normalizer._asm.AnnotationVisitor;
import org.apache.commons.weaver.normalizer._asm.ClassReader;
import org.apache.commons.weaver.normalizer._asm.ClassVisitor;
import org.apache.commons.weaver.normalizer._asm.ClassWriter;
import org.apache.commons.weaver.normalizer._asm.MethodVisitor;
import org.apache.commons.weaver.normalizer._asm.Type;
import org.apache.commons.weaver.normalizer._asm.commons.ClassRemapper;
import org.apache.commons.weaver.normalizer._asm.commons.GeneratorAdapter;
import org.apache.commons.weaver.normalizer._asm.commons.Method;
import org.apache.commons.weaver.normalizer._asm.commons.Remapper;
import org.apache.commons.weaver.normalizer._asm.commons.SimpleRemapper;
import org.apache.commons.weaver.normalizer._io.IOUtils;
import org.apache.commons.weaver.normalizer._lang3.ArrayUtils;
import org.apache.commons.weaver.normalizer._lang3.Conversion;
import org.apache.commons.weaver.normalizer._lang3.Validate;
import org.apache.commons.weaver.normalizer._lang3.mutable.MutableBoolean;
import org.apache.commons.weaver.normalizer._lang3.tuple.ImmutablePair;
import org.apache.commons.weaver.normalizer._lang3.tuple.MutablePair;
import org.apache.commons.weaver.normalizer._lang3.tuple.Pair;

public class Normalizer {
    private static final String INIT = "<init>";
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    public static final String CONFIG_WEAVER = "normalizer.";
    public static final String CONFIG_SUPER_TYPES = "normalizer.superTypes";
    public static final String CONFIG_TARGET_PACKAGE = "normalizer.targetPackage";
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final WeaveEnvironment env;
    private final Set<Class<?>> normalizeTypes;
    private final String targetPackage;

    public Normalizer(WeaveEnvironment env) {
        this.env = env;
        this.targetPackage = Utils.validatePackageName(Validate.notBlank(env.config.getProperty(CONFIG_TARGET_PACKAGE), "missing target package name", new Object[0]));
        this.normalizeTypes = Utils.parseTypes(Validate.notEmpty(env.config.getProperty(CONFIG_SUPER_TYPES), "no types specified for normalization", new Object[0]), env.classLoader);
    }

    public boolean normalize(Scanner scanner) {
        boolean result = false;
        for (Class<?> supertype : this.normalizeTypes) {
            Set<Class<?>> subtypes = this.getBroadlyEligibleSubclasses(supertype, scanner);
            try {
                Map<Pair<String, String>, Set<ClassWrapper>> segregatedSubtypes = this.segregate(subtypes);
                for (Map.Entry<Pair<String, String>, Set<ClassWrapper>> entry : segregatedSubtypes.entrySet()) {
                    Set<ClassWrapper> likeTypes = entry.getValue();
                    if (likeTypes.size() <= 1) continue;
                    result = true;
                    this.rewrite(entry.getKey(), likeTypes);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private Map<String, Map<String, ClassWrapper>> byEnclosingClass(Set<ClassWrapper> sort) {
        HashMap<String, Map<String, ClassWrapper>> result = new HashMap<String, Map<String, ClassWrapper>>();
        for (ClassWrapper wrapper : sort) {
            String outer = wrapper.wrapped.getEnclosingClass().getName();
            LinkedHashMap<String, ClassWrapper> map = (LinkedHashMap<String, ClassWrapper>)result.get(outer);
            if (map == null) {
                map = new LinkedHashMap<String, ClassWrapper>();
                result.put(outer, map);
            }
            map.put(wrapper.wrapped.getName().replace('.', '/'), wrapper);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewrite(Pair<String, String> key, Set<ClassWrapper> toMerge) throws IOException, ClassNotFoundException {
        String target = this.copy(key, toMerge.iterator().next());
        this.env.info("Merging %s identical %s implementations with constructor %s to type %s", new Object[]{toMerge.size(), key.getLeft(), key.getRight(), target});
        Map<String, Map<String, ClassWrapper>> byEnclosingClass = this.byEnclosingClass(toMerge);
        for (Map.Entry<String, Map<String, ClassWrapper>> entry : byEnclosingClass.entrySet()) {
            String outer = entry.getKey();
            this.env.debug("Normalizing %s inner classes of %s", new Object[]{entry.getValue().size(), outer});
            HashMap<String, String> classMap = new HashMap<String, String>();
            for (String merged : entry.getValue().keySet()) {
                classMap.put(merged, target);
            }
            SimpleRemapper remapper = new SimpleRemapper(classMap);
            InputStream enclosingBytecode = null;
            try {
                enclosingBytecode = this.env.getClassfile(outer).getInputStream();
                ClassReader reader = new ClassReader(enclosingBytecode);
                reader.accept(new Remap(new WriteClass(reader), remapper, classMap, entry.getValue()), 0);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(enclosingBytecode);
                throw throwable;
            }
            IOUtils.closeQuietly(enclosingBytecode);
            for (String merged : entry.getValue().keySet()) {
                if (this.env.deleteClassfile(merged)) {
                    this.env.debug("Deleted class %s", new Object[]{merged});
                    continue;
                }
                this.env.warn("Unable to delete class %s", new Object[]{merged});
            }
        }
    }

    private Set<Class<?>> getBroadlyEligibleSubclasses(Class<?> supertype, Scanner scanner) {
        ScanResult scanResult = scanner.scan(new ScanRequest().addSupertypes(new Class[]{supertype}));
        LinkedHashSet result = new LinkedHashSet();
        for (WeavableClass cls : scanResult.getClasses()) {
            IneligibilityReason reason;
            Class subtype = (Class)cls.getTarget();
            if (!subtype.isAnonymousClass()) {
                reason = IneligibilityReason.NOT_ANONYMOUS;
            } else if (subtype.getDeclaredConstructors().length != 1) {
                reason = IneligibilityReason.TOO_MANY_CONSTRUCTORS;
            } else if (subtype.getDeclaredMethods().length > 0) {
                reason = IneligibilityReason.IMPLEMENTS_METHODS;
            } else {
                result.add(subtype);
                continue;
            }
            this.env.debug("Removed %s from consideration due to %s", new Object[]{subtype, reason});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Pair<String, String>, Set<ClassWrapper>> segregate(Iterable<Class<?>> subtypes) throws IOException {
        LinkedHashMap<Pair<String, String>, Set<ClassWrapper>> classMap = new LinkedHashMap<Pair<String, String>, Set<ClassWrapper>>();
        for (Class<?> subtype : subtypes) {
            Inspector inspector = new Inspector();
            InputStream bytecode = null;
            try {
                bytecode = this.env.getClassfile(subtype).getInputStream();
                new ClassReader(bytecode).accept(inspector, 0);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bytecode);
                throw throwable;
            }
            IOUtils.closeQuietly(bytecode);
            if (inspector.ignore()) continue;
            if (inspector.valid()) {
                Pair<String, String> key = inspector.key();
                LinkedHashSet<ClassWrapper> set = (LinkedHashSet<ClassWrapper>)classMap.get(key);
                if (set == null) {
                    set = new LinkedHashSet<ClassWrapper>();
                    classMap.put(key, set);
                }
                set.add(new ClassWrapper(subtype, inspector.mustRewriteConstructor()));
                continue;
            }
            this.env.debug("%s is ineligible for normalization due to %s", new Object[]{subtype, IneligibilityReason.TOO_BUSY_CONSTRUCTOR});
        }
        return classMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copy(final Pair<String, String> key, ClassWrapper classWrapper) throws IOException, ClassNotFoundException {
        MessageDigest md5;
        this.env.debug("Copying %s to %s", new Object[]{key, this.targetPackage});
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        md5.update(key.getLeft().getBytes(UTF8));
        md5.update(key.getRight().getBytes(UTF8));
        long digest = Conversion.byteArrayToLong(md5.digest(), 0, 0L, 0, 8);
        final String result = MessageFormat.format("{0}/$normalized{1,number,0;_0}", this.targetPackage, digest);
        this.env.debug("Copying class %s to %s", new Object[]{classWrapper.wrapped.getName(), result});
        InputStream bytecode = null;
        try {
            bytecode = this.env.getClassfile(classWrapper.wrapped).getInputStream();
            ClassReader reader = new ClassReader(bytecode);
            final WriteClass writeClass = new WriteClass();
            reader.accept(new ClassVisitor(327680){
                Type supertype;

                @Override
                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    this.supertype = Type.getObjectType(superName);
                    writeClass.visit(version, 1, result, signature, superName, interfaces);
                    this.visitAnnotation(Type.getType(Marker.class).getDescriptor(), false);
                }

                @Override
                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    if (Normalizer.INIT.equals(name)) {
                        Method staticCtor = new Method(Normalizer.INIT, (String)key.getRight());
                        Type[] argumentTypes = staticCtor.getArgumentTypes();
                        Type[] exceptionTypes = Normalizer.toObjectTypes(exceptions);
                        GeneratorAdapter mgen = new GeneratorAdapter(1, staticCtor, signature, exceptionTypes, writeClass);
                        mgen.visitCode();
                        mgen.loadThis();
                        for (int i = 0; i < argumentTypes.length; ++i) {
                            mgen.loadArg(i);
                        }
                        mgen.invokeConstructor(this.supertype, staticCtor);
                        mgen.returnValue();
                        mgen.endMethod();
                        Method instanceCtor = new Method(Normalizer.INIT, Type.VOID_TYPE, ArrayUtils.add(argumentTypes, 0, OBJECT_TYPE));
                        GeneratorAdapter mgen2 = new GeneratorAdapter(1, instanceCtor, signature, exceptionTypes, writeClass);
                        mgen2.visitCode();
                        mgen2.loadThis();
                        for (int i = 0; i < argumentTypes.length; ++i) {
                            mgen2.loadArg(i + 1);
                        }
                        mgen2.invokeConstructor(this.supertype, staticCtor);
                        mgen2.returnValue();
                        mgen2.endMethod();
                        return null;
                    }
                    return null;
                }

                @Override
                public void visitEnd() {
                    writeClass.visitEnd();
                }
            }, 0);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bytecode);
            throw throwable;
        }
        IOUtils.closeQuietly(bytecode);
        return result;
    }

    private static Type[] toObjectTypes(String[] types) {
        if (types == null) {
            return null;
        }
        Type[] result = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = Type.getObjectType(types[i]);
        }
        return result;
    }

    private static enum IneligibilityReason {
        NOT_ANONYMOUS,
        TOO_MANY_CONSTRUCTORS,
        IMPLEMENTS_METHODS,
        TOO_BUSY_CONSTRUCTOR;

    }

    private class WriteClass
    extends ClassVisitor {
        private String className;

        WriteClass() {
            super(327680, new CustomClassWriter(3));
        }

        WriteClass(ClassReader reader) {
            super(327680, new CustomClassWriter(reader, 0));
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] intrfces) {
            super.visit(version, access, name, signature, superName, intrfces);
            this.className = name;
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            byte[] bytecode = ((ClassWriter)this.cv).toByteArray();
            DataSource classfile = Normalizer.this.env.getClassfile(this.className);
            Normalizer.this.env.debug("Writing class %s to %s", new Object[]{this.className, classfile.getName()});
            OutputStream outputStream = null;
            try {
                outputStream = classfile.getOutputStream();
                IOUtils.write(bytecode, outputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly(outputStream);
            }
        }
    }

    private static final class CustomClassWriter
    extends ClassWriter {
        CustomClassWriter(int flags) {
            super(flags);
        }

        CustomClassWriter(ClassReader classReader, int flags) {
            super(classReader, flags);
        }

        @Override
        protected String getCommonSuperClass(String type1, String type2) {
            return "java/lang/Object";
        }
    }

    private static class ClassWrapper {
        final Class<?> wrapped;
        final boolean mustRewriteConstructor;

        ClassWrapper(Class<?> wrapped, boolean mustRewriteConstructor) {
            this.wrapped = wrapped;
            this.mustRewriteConstructor = mustRewriteConstructor;
        }
    }

    @Target(value={ElementType.TYPE})
    private static @interface Marker {
    }

    private static final class Remap
    extends ClassRemapper {
        private final Map<String, String> classMap;
        private final Map<String, ClassWrapper> wrappers;

        private Remap(ClassVisitor wrapped, Remapper remapper, Map<String, String> classMap, Map<String, ClassWrapper> wrappers) {
            super(wrapped, remapper);
            this.classMap = classMap;
            this.wrappers = wrappers;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (!this.classMap.containsKey(name)) {
                super.visitInnerClass(name, outerName, innerName, access);
            }
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor toWrap = super.visitMethod(access, name, desc, signature, exceptions);
            return Normalizer.INIT.equals(name) ? new RewriteConstructor(toWrap) : toWrap;
        }

        private final class RewriteConstructor
        extends MethodVisitor {
            private RewriteConstructor(MethodVisitor wrapped) {
                super(327680, wrapped);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                String useDescriptor = desc;
                ClassWrapper wrapper = (ClassWrapper)Remap.this.wrappers.get(owner);
                if (wrapper != null && wrapper.mustRewriteConstructor) {
                    Type[] args = Type.getArgumentTypes(desc);
                    args[0] = OBJECT_TYPE;
                    useDescriptor = new Method(Normalizer.INIT, Type.VOID_TYPE, args).getDescriptor();
                }
                super.visitMethodInsn(opcode, owner, name, useDescriptor, itf);
            }
        }
    }

    private static final class Inspector
    extends ClassVisitor {
        private final MutablePair<String, String> key = new MutablePair();
        private final MutableBoolean ignore = new MutableBoolean(false);
        private final MutableBoolean valid = new MutableBoolean(true);
        private final MutableBoolean mustRewriteConstructor = new MutableBoolean(false);
        private String superName;

        private Inspector() {
            super(327680);
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.superName = superName;
            String left = signature != null ? signature : (ArrayUtils.getLength(interfaces) == 1 ? interfaces[0] : superName);
            this.key.setLeft(left);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (Type.getType(Marker.class).getDescriptor().equals(desc)) {
                this.ignore.setValue(true);
            }
            return null;
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return Normalizer.INIT.equals(name) ? new InspectConstructor() : null;
        }

        Pair<String, String> key() {
            return ImmutablePair.of(this.key.getLeft(), this.key.getRight());
        }

        boolean ignore() {
            return this.ignore.booleanValue();
        }

        boolean valid() {
            return this.valid.booleanValue();
        }

        boolean mustRewriteConstructor() {
            return this.mustRewriteConstructor.booleanValue();
        }

        private final class InspectConstructor
        extends MethodVisitor {
            private InspectConstructor() {
                super(327680);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                if (Normalizer.INIT.equals(name) && owner.equals(Inspector.this.superName)) {
                    Inspector.this.key.setRight(desc);
                } else {
                    Inspector.this.valid.setValue(false);
                }
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                if ("this$0".equals(name) && opcode == 181) {
                    Inspector.this.mustRewriteConstructor.setValue(true);
                    return;
                }
                Inspector.this.valid.setValue(false);
            }
        }
    }
}

