/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.privilizer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import javax.activation.DataSource;
import org.apache.commons.weaver.model.WeaveEnvironment;
import org.apache.commons.weaver.privilizer.AccessLevel;
import org.apache.commons.weaver.privilizer.BlueprintingVisitor;
import org.apache.commons.weaver.privilizer.Policy;
import org.apache.commons.weaver.privilizer.Privilizing;
import org.apache.commons.weaver.privilizer.PrivilizingVisitor;
import org.apache.commons.weaver.privilizer._asm.ClassReader;
import org.apache.commons.weaver.privilizer._asm.ClassVisitor;
import org.apache.commons.weaver.privilizer._asm.ClassWriter;
import org.apache.commons.weaver.privilizer._asm.Type;
import org.apache.commons.weaver.privilizer._asm.util.CheckClassAdapter;
import org.apache.commons.weaver.privilizer._asm.util.TraceClassVisitor;
import org.apache.commons.weaver.privilizer._io.IOUtils;
import org.apache.commons.weaver.privilizer._lang3.BooleanUtils;
import org.apache.commons.weaver.privilizer._lang3.StringUtils;
import org.apache.commons.weaver.privilizer._lang3.Validate;

public class Privilizer {
    public static final String CONFIG_WEAVER = "privilizer.";
    public static final String CONFIG_ACCESS_LEVEL = "privilizer.accessLevel";
    public static final String CONFIG_POLICY = "privilizer.policy";
    public static final String CONFIG_VERIFY = "privilizer.verify";
    private static final String GENERATE_NAME = "__privileged_%s";
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];
    final WeaveEnvironment env;
    final AccessLevel accessLevel;
    final Policy policy;
    final boolean verify;

    public Privilizer(WeaveEnvironment env) {
        this.env = env;
        this.policy = Policy.parse(env.config.getProperty(CONFIG_POLICY));
        this.accessLevel = AccessLevel.parse(env.config.getProperty(CONFIG_ACCESS_LEVEL));
        this.verify = BooleanUtils.toBoolean(env.config.getProperty(CONFIG_VERIFY));
    }

    String generateName(String simple) {
        return String.format(GENERATE_NAME, simple);
    }

    Type wrap(Type type) {
        switch (type.getSort()) {
            case 1: {
                return Type.getType(Boolean.class);
            }
            case 3: {
                return Type.getType(Byte.class);
            }
            case 4: {
                return Type.getType(Short.class);
            }
            case 5: {
                return Type.getType(Integer.class);
            }
            case 2: {
                return Type.getType(Character.class);
            }
            case 7: {
                return Type.getType(Long.class);
            }
            case 6: {
                return Type.getType(Float.class);
            }
            case 8: {
                return Type.getType(Double.class);
            }
            case 0: {
                return Type.getType(Void.class);
            }
        }
        return type;
    }

    void blueprint(Class<?> type, Privilizing privilizing) {
        Object[] args = new Object[]{type.getName(), privilizing};
        this.env.debug("blueprinting class %s %s", args);
        InputStream bytecode = null;
        try {
            bytecode = this.env.getClassfile(type).getInputStream();
            ClassReader classReader = new ClassReader(bytecode);
            PrivilizerClassVisitor cvr = new WriteClass(classReader, 3);
            cvr = new PrivilizingVisitor(this, (ClassVisitor)cvr);
            cvr = new BlueprintingVisitor(this, cvr, privilizing);
            classReader.accept(cvr, 8);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bytecode);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bytecode);
    }

    void privilize(Class<?> type) {
        Object[] args = new Object[]{type.getName()};
        this.env.debug("privilizing class %s", args);
        InputStream bytecode = null;
        try {
            bytecode = this.env.getClassfile(type).getInputStream();
            ClassReader classReader = new ClassReader(bytecode);
            PrivilizerClassVisitor cv = new WriteClass(classReader, 3);
            cv = new PrivilizingVisitor(this, (ClassVisitor)cv);
            classReader.accept(cv, 8);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bytecode);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bytecode);
    }

    void verify(String className, byte[] bytecode) {
        ClassReader reader = new ClassReader(bytecode);
        this.env.debug("Verifying bytecode for class %s", new Object[]{className});
        StringWriter w = new StringWriter();
        CheckClassAdapter.verify(reader, this.env.classLoader, false, new PrintWriter(w));
        String error = w.toString();
        if (!error.isEmpty()) {
            this.env.error(error, new Object[0]);
            StringWriter trace = new StringWriter();
            reader.accept(new TraceClassVisitor(new PrintWriter(trace)), 2);
            this.env.debug(trace.toString(), new Object[0]);
            throw new IllegalStateException();
        }
        Validate.validState(StringUtils.isBlank(error), error, new Object[0]);
        ClassVisitor checkInnerClasses = new ClassVisitor(327680, null){
            final Set<String> innerNames;
            {
                this.innerNames = new HashSet<String>();
            }

            @Override
            public void visitInnerClass(String name, String outerName, String innerName, int access) {
                super.visitInnerClass(name, outerName, innerName, access);
                Validate.validState(this.innerNames.add(innerName), "%s already defined", innerName);
            }
        };
        reader.accept(checkInnerClasses, 1);
    }

    class WriteClass
    extends PrivilizerClassVisitor {
        WriteClass(ClassReader classReader, int flags) {
            super((ClassVisitor)new CustomClassWriter(classReader, flags));
        }

        WriteClass(int flags) {
            super((ClassVisitor)new CustomClassWriter(flags));
        }

        @Override
        public void visitEnd() {
            super.visitEnd();
            byte[] bytecode = ((ClassWriter)this.cv).toByteArray();
            if (Privilizer.this.verify) {
                Privilizer.this.verify(this.className, bytecode);
            }
            DataSource classfile = Privilizer.this.env.getClassfile(this.className);
            Privilizer.this.env.debug("Writing class %s to resource %s", new Object[]{this.className, classfile.getName()});
            OutputStream outputStream = null;
            try {
                outputStream = classfile.getOutputStream();
                IOUtils.write(bytecode, outputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly(outputStream);
            }
        }
    }

    private static final class CustomClassWriter
    extends ClassWriter {
        CustomClassWriter(int flags) {
            super(flags);
        }

        CustomClassWriter(ClassReader classReader, int flags) {
            super(classReader, flags);
        }

        @Override
        protected String getCommonSuperClass(String type1, String type2) {
            return "java/lang/Object";
        }
    }

    abstract class PrivilizerClassVisitor
    extends ClassVisitor {
        String className;
        Type target;

        protected PrivilizerClassVisitor() {
            this(null);
        }

        protected PrivilizerClassVisitor(ClassVisitor cv) {
            super(327680, cv);
        }

        protected Privilizer privilizer() {
            return Privilizer.this;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            super.visit(version, access, name, signature, superName, interfaces);
            this.className = name;
            this.target = Type.getObjectType(name);
        }
    }
}

