/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.weaver.maven;

import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.weaver.maven.JavaLoggingToMojoLoggingRedirector;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.ScopeDependencyFilter;

abstract class AbstractCWMojo
extends AbstractMojo {
    @Parameter(defaultValue="false")
    protected boolean verbose;
    @Parameter(property="weaver.config", required=false)
    protected Properties weaverConfig;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Component
    protected RepositorySystem repositorySystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    protected RepositorySystemSession repositorySystemSession;

    AbstractCWMojo() {
    }

    protected abstract File getTarget();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws MojoExecutionException, MojoFailureException {
        JavaLoggingToMojoLoggingRedirector logRedirector = new JavaLoggingToMojoLoggingRedirector(this.getLog());
        logRedirector.activate();
        try {
            List<String> classpath;
            try {
                classpath = this.createClasspath();
            }
            catch (DependencyResolutionException e) {
                throw new MojoExecutionException("Error getting classpath artifacts", (Exception)((Object)e));
            }
            File target = this.getTarget();
            Properties config = this.weaverConfig == null ? new Properties() : this.weaverConfig;
            this.getLog().debug((CharSequence)String.format("classpath=%s%ntarget=%s%nconfig=%s", classpath, target, config));
            this.doExecute(target, classpath, config);
        }
        finally {
            logRedirector.deactivate();
        }
    }

    protected abstract void doExecute(File var1, List<String> var2, Properties var3) throws MojoExecutionException, MojoFailureException;

    private List<String> createClasspath() throws DependencyResolutionException {
        CollectRequest collect = new CollectRequest();
        collect.setRootArtifact(RepositoryUtils.toArtifact((Artifact)this.project.getArtifact()));
        collect.setRequestContext("project");
        collect.setRepositories(this.project.getRemoteProjectRepositories());
        for (Dependency dependency : this.project.getDependencies()) {
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()})) continue;
            collect.addDependency(RepositoryUtils.toDependency((Dependency)dependency, (ArtifactTypeRegistry)this.repositorySystemSession.getArtifactTypeRegistry()));
        }
        DependencyResult dependencyResult = this.repositorySystem.resolveDependencies(this.repositorySystemSession, new DependencyRequest().setFilter((DependencyFilter)new ScopeDependencyFilter(this.getExcludeScopes())).setCollectRequest(collect));
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ArtifactResult artifactResult : dependencyResult.getArtifactResults()) {
            result.add(artifactResult.getArtifact().getFile().getAbsolutePath());
        }
        return new ArrayList<String>(result);
    }

    private String[] getExcludeScopes() {
        String[] stringArray;
        if (((Object)((Object)this)).getClass().isAnnotationPresent(TestScope.class)) {
            stringArray = ArrayUtils.EMPTY_STRING_ARRAY;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "test";
        }
        return stringArray;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface TestScope {
    }
}

