(function($) {

	
	//Web Forms 2.0
	window.webforms = 1;
	if(window['webforms']) {
		$(document).ready(function() {
			
			$("input").each(function() {
				if(this.getAttribute("type") == "range") {
					var cur = $(this);
					var slider = $("<div class='ui-slider'></div>").css({ width: cur.innerWidth()+"px", height: cur.innerHeight()+"px" }).insertAfter(cur);
					var handle = $("<div class='ui-slider-handle'></div>").appendTo(slider);


					slider.css({
						"position": cur.css("position") == "absolute" ? "absolute" : "relative",
						"left": cur.css("left"),
						"right": cur.css("right"),
						"zIndex": cur.css("zIndex"),
						"float": cur.css("float"),
						"clear": cur.css("clear")
					});
					cur.css({ position: "absolute", opacity: 0, top: "-1000px", left: "-1000px" });
					
					slider.slider({
						maxValue: cur.attr("max"),
						minValue: cur.attr("min"),
						startValue: this.getAttribute("value"),
						stepping: cur.attr("step"),
						change: function(e, ui) { cur[0].value = ui.value; cur[0].setAttribute("value", ui.value); }
					});
					
					slider = slider.sliderInstance();
					
					cur.bind("keydown", function(e) {
						var o = slider.interaction.options;
						switch(e.keyCode) {
							case 37:
								slider.moveTo(slider.interaction.curValue+o.minValue-(o.stepping || 1));
								break;
							case 39:
								slider.moveTo(slider.interaction.curValue+o.minValue+(o.stepping || 1));
								break;	
						}
						if(e.keyCode != 9) return false;
					});
					
				};	
			});
				
		});
	}

	//Make nodes selectable by expression
	$.extend($.expr[':'], { slider: "(' '+a.className+' ').indexOf(' ui-slider ')" });
	
	$.fn.slider = function(o) {
		return this.each(function() {
			new $.ui.slider(this, o);
		});
	}
	
	//Macros for external methods that support chaining
	var methods = "destroy,enable,disable,moveTo,reconfigure".split(",");
	for(var i=0;i<methods.length;i++) {
		var cur = methods[i], f;
		eval('f = function() { var a = arguments; return this.each(function() { if(jQuery(this).is(".ui-slider")) jQuery.data(this, "ui-slider")["'+cur+'"](a); }); }');
		$.fn["slider"+cur.substr(0,1).toUpperCase()+cur.substr(1)] = f;
	};
	
	//get instance method
	$.fn.sliderInstance = function() {
		if($(this[0]).is(".ui-slider")) return $.data(this[0], "ui-slider");
		return false;
	};
	
	$.ui.slider = function(el, o) {
		
		var options = {};
		o = o || {};
		$.extend(options, o);
		$.extend(options, {
			axis: o.axis || (el.offsetWidth < el.offsetHeight ? 'vertical' : 'horizontal'),
			maxValue: parseInt(o.maxValue) || 100,
			minValue: parseInt(o.minValue) || 0,
			startValue: parseInt(o.startValue) || 0,
			handleHotspot: o.handleHotspot || [],
			_start: function(h, p, c, t, e) {
				self.start.apply(t, [self, e]); // Trigger the start callback				
			},
			_beforeStop: function(h, p, c, t, e) {
				self.stop.apply(t, [self, e]); // Trigger the start callback
			},
			_drag: function(h, p, c, t, e) {
				self.drag.apply(t, [self, e]); // Trigger the start callback
			},
			startCondition: function() {
				return !self.disabled;
			}			
		});
		this.options = options;
		var self = this;
		var o = this.options;
		$.data(el, "ui-slider", this);
		o.stepping = parseInt(o.stepping) || (o.steps ? o.maxValue/o.steps : 0);
		o.realValue = (o.maxValue - o.minValue);


		this.handle = o.handle ? $(o.handle, el) : $('.ui-slider-handle', el);
		if(this.handle.length == 1) {
			this.interaction = new $.ui.mouseInteraction(this.handle[0], o);
			this.multipleHandles = false;
		} else {
			this.interactions = [];
			this.handle.each(function() {
				self.interactions.push(new $.ui.mouseInteraction(this, o));
			});
			this.multipleHandles = true;
		}
				
		this.handle.each(function(i){
			o.handleHotspot[i] = o.handleHotspot[i] || [this.offsetWidth/2, this.offsetHeight/2];
		});
		
		this.element = el;
		$(this.element).addClass("ui-slider");
		
		
		if(o.axis == 'horizontal') {
			var last = o.handleHotspot.length - 1;
			this.parentSize = $(this.element).outerWidth() - o.handleHotspot[0][0] - ($(this.handle[last]).outerWidth() - o.handleHotspot[last][0]);
			this.prop = 'left';
		}
		
		if(o.axis == 'vertical') {
			var last = o.handleHotspot.length - 1;
			this.parentSize = $(this.element).outerHeight() - o.handleHotspot[0][1] - ($(this.handle[last]).outerHeight() - o.handleHotspot[last][1]);
			this.prop = 'top';
		}
		
		if(!this.multipleHandles) {
			$(el).bind('click', function(e) { self.click.apply(self, [e]); });
			if(!isNaN(o.startValue)) this.moveTo(o.startValue, o.realValue, true, false);
		} else {
			if(o.startValues) 
				this.moveTo(o.startValues, o.realValue, true, false);
		}
	}
	
	$.extend($.ui.slider.prototype, {
		currentTarget: null,
		lastTarget: null,
		destroy: function() {
			$(this.element).removeClass("ui-slider").removeClass("ui-slider-disabled");
			this.interaction.destroy();
		},
		enable: function() {
			$(this.element).removeClass("ui-slider-disabled");
			this.disabled = false;
		},
		disable: function() {
			$(this.element).addClass("ui-slider-disabled");
			this.disabled = true;
		},
		calcValue: function (pxValue, pxWidth, valueRange, stepping, interactionsIndex) {
			var curValue;	

			if(pxValue < 0) pxValue = 0;
			if(pxValue > pxWidth) pxValue = pxWidth;

			curValue = (Math.round((pxValue / pxWidth) * valueRange));
			
			if(stepping) 
				curValue = Math.round(curValue / stepping) * stepping;	
			
			if(interactionsIndex != null && this.interactions) {
				if(this.interactions[interactionsIndex-1]) {
					if(this.interactions[interactionsIndex-1].curValue > curValue) 
						curValue = this.interactions[interactionsIndex-1].curValue;
				}
				
				if(this.interactions[interactionsIndex+1]) {
					if(this.interactions[interactionsIndex+1].curValue < curValue) 
						curValue = this.interactions[interactionsIndex+1].curValue;
				}
			}
			
			pxValue = (curValue / valueRange) * pxWidth;
			return {pxValue: pxValue, curValue: curValue};		
		},
		prepareCallbackObj: function(self,m) {
			
			var cur = this;
			var o = this.options;
			var func = function() {
				var retVal = [];
				for(var i=0; i<cur.interactions.length; i++) {
					retVal.push((cur.interactions[i].curValue || 0) + o.minValue);
				}
				return retVal;
			};
			
			return {
				handle: self.helper,
				pixel: m,
				value: self.curValue + o.minValue,
				values: this.multipleHandles ? func() : self.curValue + o.minValue,
				slider: self	
			}			
		},
		reconfigure: function (args) {
			var o = args[0];
			this.options.minValue = o.minValue || this.options.minValue;
			this.options.maxValue = o.maxValue || this.options.maxValue;
			this.options.stepping = parseInt(o.stepping) || (o.steps ? this.options.maxValue/o.steps : 0);
			this.options.realValue = (this.options.maxValue - this.options.minValue);
			
			o = this.options;
			
			if (this.multipleHandles){
				var startValues = [];
				for (var i=0; i<this.interactions.length; i++){
					var offset = $(this.interactions[i].element).offsetParent().offset({ border: false })
					
					if(o.axis == 'horizontal') var displacement = -o.handleHotspot[0][0] + o.handleHotspot[i][0];
					if(o.axis == 'vertical')   var displacement = -o.handleHotspot[0][1] + o.handleHotspot[i][1];
		
					if(o.axis == 'horizontal') var m = this.interactions[i].element.offsetLeft + displacement;
					if(o.axis == 'vertical')   var m = this.interactions[i].element.offsetTop + displacement;
					
					r = this.calcValue(m, this.parentSize, o.realValue, o.stepping, null);
					startValues.push(o.minValue+r.curValue);					
				}
				this.moveTo(startValues, o.realValue, true, false);
			} else {
				$(this.element).triggerHandler("slide", [null, this.prepareCallbackObj(this.interaction)], this.options.slide);
			}
			
		},
		click: function(e) {
			var o = this.interaction.options;
			var pointer = [e.pageX,e.pageY];
			var offset = $(this.interaction.element).offsetParent().offset({ border: false });
			if(this.interaction.element == e.target || this.disabled) return;
			
			this.interaction.pickValue = this.interaction.curValue;
			this.drag.apply(this.interaction, [this, e, [pointer[0]-offset.left-this.handle[0].offsetWidth/2,pointer[1]-offset.top-this.handle[0].offsetHeight/2]]);
			
			if(this.interaction.pickValue != this.interaction.curValue)
				$(this.element).triggerHandler("slidechange", [e, this.prepareCallbackObj(this.interaction)], o.change);
				
		},
		start: function(that, e) {
			
			var o = this.options;
			$(that.element).triggerHandler("slidestart", [e, that.prepareCallbackObj(this)], o.start);
			this.pickValue = this.curValue;
			
			return false;
						
		},
		stop: function(that, e) {			
			
			var o = this.options;
			$(that.element).triggerHandler("slidestop", [e, that.prepareCallbackObj(this)], o.stop);
			if(this.pickValue != this.curValue) $(that.element).triggerHandler("slidechange", [e, that.prepareCallbackObj(this)], o.change);

			return false;
			
		},
		drag: function(that, e, pos) {

			var o = that.options;
			this.pos = pos || this.pos;
			
			var interactionIndex = that.interactions ? $(that.interactions).index(this) : 0;
			if(o.axis == 'horizontal') var displacement = -o.handleHotspot[0][0] + o.handleHotspot[interactionIndex][0];
			if(o.axis == 'vertical')   var displacement = -o.handleHotspot[0][1] + o.handleHotspot[interactionIndex][1];
			
			if(o.axis == 'horizontal') var m = this.pos[0] - this.element.offsetWidth/2;
			if(o.axis == 'vertical')   var m = this.pos[1] - this.element.offsetHeight/2;
			
			m += displacement;

			r = that.calcValue(m, that.parentSize, o.realValue, o.stepping, interactionIndex);
			this.curValue = r.curValue;	

			$(this.element).css(that.prop, (r.pxValue - displacement)+'px');
			$(that.element).triggerHandler("slide", [e, that.prepareCallbackObj(this, r.pxValue)], o.slide);
			return false;
			
		},
		moveTo: function(value,scale,changeslide,p,interactionIndex) {
			var o = this.options;	
							
			if (this.multipleHandles) {
				var values = value;
				for(i = 0; i < values.length; i++) {								
					var offset = $(this.interactions[i].element).offsetParent().offset({ border: false });
					this.interactions[i].pickValue = this.interactions[i].curValue;
					
					if(o.axis == 'horizontal') var displacement = -o.handleHotspot[0][0] + o.handleHotspot[i][0];
					if(o.axis == 'vertical')   var displacement = -o.handleHotspot[0][1] + o.handleHotspot[i][1];
			
					value = values[i]-o.minValue;
					
					var modifier = scale || o.realValue;
					
					var p = p || this.parentSize;				
					
					m = Math.round(((value)/modifier) * p);					
					r = this.calcValue(m, this.parentSize, o.realValue, o.stepping);
					this.interactions[i].curValue = r.curValue;						
						
					$(this.interactions[i].element).css(this.prop, (r.pxValue - displacement)+'px');
					
					if(!changeslide && this.interactions[i].pickValue != this.interactions[i].curValue && !p)
						$(this.element).triggerHandler("slidechange", [null, this.prepareCallbackObj(this.interactions[i])], o.change);
					
					if(changeslide)
						$(this.element).triggerHandler("slide", [null, this.prepareCallbackObj(this.interactions[i])], o.slide);
				}			
			} else {			
				var offset = $(this.interaction.element).offsetParent().offset({ border: false });
				this.interaction.pickValue = this.interaction.curValue;

				value = value-o.minValue;
				
				var modifier = scale || o.realValue;
				
				var p = p || this.parentSize;				
				
				m = Math.round(((value)/modifier) * p);
				
				r = this.calcValue(m, this.parentSize, o.realValue, o.stepping);
				this.interaction.curValue = r.curValue;						
					
				$(this.interaction.element).css(this.prop, r.pxValue+'px');
				
				if(!changeslide && this.interaction.pickValue != this.interaction.curValue && !p)
					$(this.element).triggerHandler("slidechange", [null, this.prepareCallbackObj(this.interaction)], o.change);
				
				if(changeslide)
					$(this.element).triggerHandler("slide", [null, this.prepareCallbackObj(this.interaction)], o.slide);
			}
		}
	});

})(jQuery);
