/*	Original:  Kevin Peno (kevin@metalaxe.com)
	Web Site:  http://metalaxe.com

	Version: 1.0 alpha
	Date: 10/30/2007 @ 21:28 PST (-8 GMT)
	Requirements: jQuery, jQuery.ui.draggable
*/

function Battleship()
{
	/*
		Store ths OS window ID
	*/
	this.window = null;
	
	/*
		Dragged ship is rotated
	*/
	this.dragged = '';
	
	/*
		Store ths OS window name
	*/
	this.name = 'Battleship';
	
	/**
	*	Path to prgram
	**/
	this.program_dir = 'programs/battleship/';

	/*
	*	Game State (nothing/setup/battle)
	*/
	this.gameState = false;

	/*
		Information used to describe ships
	*/
	this.shiptypes = {
		cv : [ 'Aircraft Carrier',	5,	'carrier',		false],
		bb : [ 'Battleship',		4,	'battleship',	false],
		ss : [ 'Submarine',			3,	'sub',			false],
		dd : [ 'Destroyer',			3,	'destroyer',	false],
		pt : [ 'Patrol Boat',		2,	'patrol',		false]
	};
	
	/**
		Example player object
	
		this.player = {
						ships:
						{
							shipcall (ie. CV) :
							[
								X pos	(ie. 1),
								Y pos	(ie. A [numeric of] ),
								lives,
								direction	(true/false) (aka horizontal/vertical)
							]
						},
						grid:
						[
						 	[0,0,0,0,0,0,0,0,0,0],
							etc
						]
					};
	**/

		
	/*
		Player Elements
	*/
	this.player = {
		ships:
		{
			count: 0
		},
		grid: [
			[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0]
		]
	};

	/*
		Computer Elements
	*/
	this.enemy = {
		ships:
		{
			count: 0
		},
		grid: [
			[-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0],
			[-1,0,0,0,0,0,0,0,0,0,0]
		]
	};
}
/*
Start the game!
*/
Battleship.prototype.Init = function( window_id, params )
{
	this.window = window_id;

	// Change game state to setup
	this.gameState = 'setup';

	// For call backs
	var self = this;

	$(".ships").draggable({
		cursor: 'move',
		cursorAt: {bottom:13, left:13},
		start: function()
		{
			$(document).keypress( function(e){ self.rotateImage(e); });
			self.dragged = $(this).attr('id');
			if( self.player.ships.count == 5 )
				$('#start').hide();

		},
		stop: function()
		{
			$(document).unbind('keypress');
			self.dragged = '';
		}
	});

	$('#shipselect').show();

	$('#player div').droppable({
		accept : 'img',
		tolerance : 'pointer',
		drop : function(e,ui){ self.placePlayerShip(e,ui); },
	});
	$('#player').show();

	$('#start').click( function(e){ self.start(e); } );
}

/*
*	Start the actual fighting
*/
Battleship.prototype.start = function( e )
{
	if( this.player.ships.count < 5 )
	{
		alert( 'You must place all of your ships before the game can begin' );
		return false;
	}

	$('#start').hide();

	// Remove the dragg/droppability
	$('.ships').draggableDisable().unbind('dblclick');
	$('#player div').droppableDisable();

	// Do something to prevent user interaction while generating computer placement

	//Set up enemy zone
	this.setupEnemy();
	var self = this;
	$('#enemy div').bind("click", function(e){ self.fireShot(e) } )
		.parent().show();

	// Remove ship select screen
	$('#shipselect h3').hide();
	$('#ships img').css('cursor','default');
	this.gameState = 'battle';
}

/*
	Function create the enemy grid
*/
Battleship.prototype.setupEnemy = function()
{
	// Loop through all shiptypes
	for( var ship_key in this.shiptypes )
	{
		var revertToGrid = this.enemy.grid;
		this.placeEnemyShip( ship_key, revertToGrid );
	}
	var stopit = false;
}

/*
	Function to place the ships in the NPC grid
*/
Battleship.prototype.placeEnemyShip = function( ship_key, revertToGrid )
{
	// Vertical or horizontal for this ship
	var direction = Math.floor(Math.random()*2) == 0 ? true : false;
	var cellx = Math.floor( ( Math.random() * 10 ) + 1 );
	var celly = Math.floor( ( Math.random() * 10 ) + 1 );

	// Check for enough room
	var conflict = false;

	if( direction )
	{
		/*Vertical*/
		if( ( celly + this.shiptypes[ ship_key ][1] ) > 10 )
		{
			conflict = true;
		}
	}
	else if( ( cellx + this.shiptypes[ ship_key ][1] ) > 10 )
	{
		conflict = true;
	}

	if( !conflict )
	{
		// Check we don't overlap other ships
		var x = cellx;
		var y = celly;
		var i = 0;
		// Apply this ship's location while we're here
		do{
			if( this.enemy.grid[ y ][ x ] != 0 )
				conflict = true;
			else
			{
				this.enemy.grid[ y ][ x ] = ship_key;
				i++;
				if( direction )
					y++;
				else
					x++;
			}
		}while( !conflict && i < this.shiptypes[ ship_key ][1] );
	}

	if( conflict )
	{
		// Revert and try again till there are no conflicts
		this.enemy.grid = revertToGrid;
		this.placeEnemyShip( ship_key, revertToGrid );
	}
	else
	{
		//Update the enemy ship node
		this.enemy.ships[ ship_key ] = [ cellx, celly, this.shiptypes[ ship_key ][1], direction ];
		this.enemy.ships.count++;
	}
}

/**
*	Place Ship on grid during setup
**/
Battleship.prototype.placePlayerShip = function( e, jquery_ui )
{
	// Find our stuffs
	var target = this.findCell( e, jquery_ui );
	var ship = $(jquery_ui.draggable.element);
	var ship_key = $(ship).attr('id');

	// If we haven't picked a ship this does nothing
	if( !ship )
	{
		return false;
	}

	// Did we move this ship before?
	if( typeof( this.player.ships[ ship_key ] ) == 'object' && typeof( this.player.ships[ ship_key ][0] ) != 'undefined' )
	{
		// Clear the previous entries in the grid
		var ox = this.player.ships[ ship_key ][0];
		var oy = this.player.ships[ ship_key ][1];

		for( var oi = 0; oi < this.shiptypes[ ship_key ][1]; oi++ )
		{
			this.player.grid[ oy ][ ox ] = 0;
			if( this.player.ships[ ship_key ][3] )
				oy++;
			else
				ox++;
		}
		// Remove from the tally
		if( this.player.ships.count == 5 )
			$('#start').hide();

		this.player.ships.count--;
		this.player.ships[ ship_key ] = null;
	}

	// Check for enough room
	var conflict = false;
	var revertToGrid = this.player.grid;

	// Check we don't overlap other ships or hit the end of the grid
	var x = target.x;
	var y = target.y;
	var i = 0;

	// Apply this ship's location while we're here
	do{
		if( this.player.grid[ y ][ x ] != 0)
			conflict = true;
		else
		{
			this.player.grid[ y ][ x ] = ship_key;
			i++;
			if( this.shiptypes[ ship_key ][3] )
				y++;
			else
				x++;
		}
	}while( !conflict && i < this.shiptypes[ ship_key ][1] && y < 11 && x < 11 );

	// See if we hit the end of the line
	if( ( y == 11 || x == 11 ) && i < this.shiptypes[ ship_key ][1] )
		conflict = true

	if( conflict )
	{
		alert( 'Please place the ' + this.shiptypes[ ship_key ][0] + ' to where all sides are within the ocean grid and not touching squares containing any other ships' );
		$(ship).css({ 'position' : 'relative', 'top': '0', 'left' : '0' });
		this.player.grid = revertToGrid;
		return false;
	}
	
	// Move the ship image to the grid where selected
	$(ship).css({
		'top': target.offset.top,
		'left' : target.offset.left
	});
	
	//Update the player node
	this.player.ships[ ship_key ] = [ target.x, target.y, this.shiptypes[ ship_key ][1], this.shiptypes[ ship_key ][3] ];
	this.player.ships.count++;

	// Show start button
	if( this.player.ships.count === 5 )
		$('#start').show();

	// Remove draggability
	var self = this;
	$(ship).draggableDisable()
		.dblclick( function()
		{
			$(this).draggableEnable();
			$(this).unbind('dblclick');
		}
	);

	return true;
}

/**
*	Find the true targeted cell
*	Used during ship placement
**/
Battleship.prototype.findCell = function( e, jquery_ui )
{
	// Returned object
	var target = { x:null, y:null, offset:null };

	//Ship
	var draggable = jquery_ui.draggable.element;

	//Grid sizes
	var gridx = 30;
	var gridy = 30;
	
	//Grid div calcs
	var droppable = jquery_ui.draggable.currentTarget;
	var droppable_inset = $(droppable).offset();

	// Ship Image calcs
	var draggable_offset = $(draggable).offset();
	var draggable_inset_x = ( draggable_offset.left - droppable_inset.left );
	var draggable_inset_y = ( draggable_offset.top - droppable_inset.top );

	// Besure we have no negatives
	if(	draggable_inset_x < 1 )
		draggable_inset_x = 1;
	if(	draggable_inset_y < 1 )
		draggable_inset_y = 1;		

	// "Grid" location calulations - gives a soft leniency of 5px overhanging
	target.x = ( draggable_inset_x % gridx ) < 25 ? Math.floor( draggable_inset_x / gridx ) : Math.ceil( draggable_inset_x / gridx );
	target.y = ( draggable_inset_y % gridy ) < 25 ? Math.floor( draggable_inset_y / gridy ) : Math.ceil( draggable_inset_y / gridy );

	// Finalized offsets
	target.offset = {
		top: (target.y * gridy + droppable_inset.top),
		left: (target.x * gridx + droppable_inset.left)
	};

	return target;
}

/**
*	Fire a shot at the enemy!
**/
Battleship.prototype.fireShot = function( e )
{
	//Grid sizes
	var gridx = 30;
	var gridy = 30;
	
	//Grid div calcs
	var target = this.getTarget( e );
	var target_inset = $(target).offset();

	// Ship Image calcs
	var inset_x = ( e.clientX - target_inset.left );
	var inset_y = ( e.clientY - target_inset.top );

	// Besure we have no negatives
	if(	inset_x < 1 )
		return false;
	if(	inset_y < 1 )
		return false;		

	// "Grid" location calulations - gives a soft leniency of 5px overhanging
	var x = ( inset_x % gridx ) < 28 ? Math.floor( inset_x / gridx ) : Math.ceil( inset_x / gridx );
	var y = ( inset_y % gridy ) < 28 ? Math.floor( inset_y / gridy ) : Math.ceil( inset_y / gridy );

	// Reverse the x count for reverse field
	x = ( x - 10 ) * -1;

	if( this.enemy.grid[ y ][ x ] != 0 )
		alert( 'Hit' );
	else
		alert('Miss');
}

/**
*	Function to display a hit/miss icon
*/
Battleship.prototype.setImage = function( y, x, id, ispc )
{
}

/*
	Function to make the computers move. Note that the computer does not cheat, oh no!
*/
Battleship.prototype.computerMove = function()
{
}

/*
	When whole ship is hit, show it using changed graphics
*/
Battleship.prototype.sinkShip = function( grid, shipno, ispc )
{
}

/*
	Show location of all the enemy ships - when game is over
*/
Battleship.prototype.knowYourEnemy = function()
{
}

/**
*	gets a valid grid target
**/
Battleship.prototype.getTarget = function( e )
{
	var target;
	//W3C
	if (e.target) target = e.target;
	//MS
	else if (e.srcElement) target = e.srcElement;

	// defeat Safari bug
	if (target.nodeType == 3)
	{
		target = target.parentNode;
	}

	return target;
}

/**
*	Used to change a ship from horizontal to vertical
*	during drag operation
*	must use 'this' instead of 'this'
**/
Battleship.prototype.rotateImage = function( e )
{
	if( e.which == 92 )
	{
		//Update the image source
		var source = $('#' + this.dragged ).attr('src');
		var to_replace = this.shiptypes[ this.dragged ][3] ? 'v_' + this.shiptypes[ this.dragged ][2] : this.shiptypes[ this.dragged ][2];
		var replace_with = this.shiptypes[ this.dragged ][3] ? this.shiptypes[ this.dragged ][2] : 'v_' + this.shiptypes[ this.dragged ][2];
		source = source.replace( to_replace, replace_with );

		$('#' + this.dragged ).attr({ 'src' : source }).css({
			'width': $('#' + this.dragged ).css('height'),
			'height': $('#' + this.dragged ).css('width')
		});
		
		this.shiptypes[ this.dragged ][3] = this.shiptypes[ this.dragged ][3] ? false : true;
	}

	return e;	
}