/* Copyright (c) 2007 Kevin Peno (kevin@metalaxe.com)
 * Licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
 *
 * $LastChangedDate: $
 * $Rev: $
 *
 * Version: 0.1
 *
 * Requires: jQuery 1.2.1+
 */
(function($)
{
	/*
		User keys to index relationship
	*/
	var styleSheets = {};

	/*
		styleSheetObj
		@param		int		offset in styleSheetList object
		@return		obj		styleSheet object or null
	*/
	function styleSheetObj( offset, name )
	{
		if( !document.styleSheets[ offset ] )
			throw( 'StyleSheet requested does not exist!' );

		this.key = offset;
		if( name )
			styleSheets[ name ] = this;
		else
			styleSheets[ key ] = this;
	};

	/*
		Type
		@return		string
	*/
	styleSheetObj.prototype.type = function()
	{
		return document.styleSheets[ this.key ].type;
	};

	/*
		Disabled (toggle)
		@param		bool
		@return		mixed	current value or styleSheet object
	*/
	styleSheetObj.prototype.disabled = function( swap )
	{
		if( swap )
		{
			document.styleSheets[ this.key ].disabled = document.styleSheets[ this.key ].disabled ? false : true;
			return styleSheets[ this.key ];
		}
		else
			return document.styleSheets[ this.key ].disabled;
	};

	/*
		OwnerNode
		@return		string
	*/
	styleSheetObj.prototype.ownerNode = function()
	{
		if( $.browser.msie )
			return document.styleSheets[ this.key ].owningElement;
		else
			return document.styleSheets[ this.key ].ownerNode;
	};

	/*
		ParentStyleSheet
		@return		obj		styleSheet Obj
	*/
	styleSheetObj.prototype.parentStyleSheet = function()
	{
		//Need to find a way to wrap this in in our plugin...
		//document.styleSheets[ this.key ].parentStyleSheet;
	};

	/*
		HREF
		@return		obj		styleSheet Obj
	*/
	styleSheetObj.prototype.href = function( newhref )
	{
		if( document.getElementsByTagName('base').length )
		{
			return document.getElementsByTagName('base').href + document.styleSheets[ this.key ].href;
		}
		else
		{
			return document.styleSheets[ this.key ].href;
		}
	};

	/*
		addImport
		@param		string	URI
		return		obj		styleSheet
	*/
	styleSheetObj.prototype.addImport = function( uri, index )
	{
		return $.importStyleSheet( this.key, uri, index );
	};

	/*
		jStyleSheet
	*/
	$.fn.styleSheet = function( key, name )
	{
		var truekey = name ? name : key;

		return this.each( function(){
			if( styleSheets[ key ] )
				return styleSheets[ key ];
			else
			{
				try{
					new styleSheet( key, name );
				} catch(e) {
					return null;
				}
				return styleSheets[ truekey ];
			}
		});
	};

	$.fn.importStyleSheet = function( key, uri, index )
	{
		//Add stylesheet first if we have none
		if( isNaN(key) || !uri || $.fn.styleSheet( key, name ) == null )
			return false;

		return this.each( function() {
			if( $.browser.msie == true && $.browser.version >= 5.5 )
			{
				document.styleSheets[ key ].addImport( uri, index );
				return true;
			}
			else if( document.styleSheets )
			{
				document.styleSheets[ key ].insertRule('@import "'+uri+'";', index );
				return true;
			}
			return false;
	   });
	};

	/*
		addStyleSheet
		@param		obj		options
		return		bool
	*/
	$.fn.addStyleSheet = function( options )
	{
		options = $.fn.extend( $.fn.addStyleSheet.defaults, options || {});
		
		return this.each( function() {
			// Gecko
			if( !$.browser.msie && document.styleSheets )
			{
				var success = true;
				try
				{
					// Gecko doesn't always work when adding link or style tags (mostly when using XSL)
					$(document.createElement('style')).appendTo('head');
				} catch (e){
					setTimeout( $.addStyleSheet(options), 100);
					success = false;
				}
	
				if( success )
				{
					key = ( document.styleSheets.length - 1 );
					if( options.href != null )
						 document.styleSheet[ key ].insertRule('@import "' + options.href + '";');
				}
			}
			else if( $.browser.msie && $.browser.version >= 5.5 )
			{
				var key = document.addStyleSheet( options.href, options.index );
			}
	
			if( key )
			{
				$( $.styleSheet( key ).ownerNode ).attr({
							type:	options.type,
							media:	options.media,
							title:	options.title
				});
	
				//Save for later "easy access"?
				if( options.id != null )
					styleSheets[ options.id ] = $.styleSheet( key );
			}
		});
	};
	
	$.fn.addStyleSheet.defaults = {
		id:		null,		//Only used to store in key translation
		type:	'text/css',
		media:	'all',
		href:	null,			//If specified performs addition using @import rule
		title:	'',
		index:	0			//Used to assign stylesheet in a "less important" position in the dom
	};

})(jQuery);