/* Copyright (c) 2007 Kevin Peno (kevin@metalaxe.com) and Justin Shreve (justin@metalaxe.com)
 * Licensed under the MIT (http://www.opensource.org/licenses/mit-license.php)
 *
 * $LastChangedDate: $
 * $Rev: $
 *
 * Version: 0.1
 *
 * Requires: jQuery 1.2.1+
 */
(function($)
{
	/**
		Private Stuffs
	**/
	var xslCache = {};

	/**
	*	Shamelessly ripped from jQuery core
	**/
	function evalScript(elem){
		var script = jQuery.nodeName(elem, "script");
	
		if ( script ) {
			if ( elem.src )
				$.ajax({ url: elem.src, async: false, dataType: "script" });
			else
				$.globalEval( elem.text || elem.textContent || elem.innerHTML || "" );
		
			if ( elem.parentNode )
				elem.parentNode.removeChild(elem);
	
		} else if ( elem.nodeType == 1 )
		$("script", elem).each(evalScript);
	
		return script;
	}

	function jXSLProcessor( options ){
		this.options	=	options;
		this.output		= 	'';
	};

	jXSLProcessor.prototype.loadXMLFile = function( file ){
		var data = null;

		$.ajax({
			url: file,
			async: false,
			dataType: 'xml',
			success: function( response, status ){
				data = response;
				return true;
			}
		 });
		return data;
	};

	jXSLProcessor.prototype.transform = function( xml, xsl ){
		if( !xml )
			throw( 'XML file Missing or invalid' );

		var XSLT = null;

		// See if XSL was passed via XML file
		if( !xsl && $('xsl',xml).length > 0 && $('xsl',xml).attr('href') )
		{
			xsl = $('xsl',xml).attr('href');
		}

		//Make sure we have XSL by now
		if( !xsl )
			throw( 'XSL file missing or invalid!');

		if( this.options.useCache && xslCache[ xsl ] )
		{
			XSLT = xslCache[ xsl ];
		}


		$('style',xml).importStyleSheet(0, $('style',xml).attr('href') );
		$.ajaxSetup({async: false});
		$('script',xml).each( function(){ $.getScript( $(this).attr('href') ); });
		$.ajaxSetup({async: true});

		// IE 7
		if( window.ActiveXObject )
		{
			if( XSLT == null )
			{
				XSLT = new ActiveXObject("MSXML2.FreeThreadedDOMDocument");
				XSLT.async = false;
				try {
					XSLT.load( xsl );
				} catch(e) {
					return false;
				}

				if( this.options.useCache )
					xslCache[ xsl ] = XSLT;
			}

			var template = new ActiveXObject("MSXML2.XSLTemplate");
			template.stylesheet = XSLT;
			var process = template.createProcessor();
		    process.input = xml;
		    process.transform();

			this.output = process.output;
			return true;
		}
	    // Firefox
	    else if( window.XSLTProcessor )
		{
			if( XSLT == null )
			{
				XSLT = document.implementation.createDocument("", "", null);
				XSLT.async = false;
				try {
					XSLT.load( xsl );
				} catch(e) {
					return false;
				}
			}

			var process = new XSLTProcessor();
	      	process.importStylesheet( XSLT );
	      
	      	this.output = process.transformToFragment( xml, document );
			return true;
	    }

		return false;
	}

	jXSLProcessor.prototype.getTransform = function( element ){
		if( this.options.append )
			$(this.output).appendTo(element);
		else
			$(element).html( this.output );

		if( this.options.eval )
			 evalScript( this.output );
	}

	/*
		Jquery stuffs
	*/
	$.fn.ajaxTransform = function( xml, xsl, options ){

		options = $.fn.extend( $.fn.ajaxTransform.defaults, options || {} );

		if( !xml )
			throw( 'no XML passed' );

		var processor = new jXSLProcessor( options );
		var doc = processor.loadXMLFile( xml );
		if( processor.transform( doc, xsl ) == false )
			throw( 'failed to transform file' );

		return this.each( function(){
			processor.getTransform( this );
		});
	};

	$.fn.ajaxTransform.defaults = {
		useCache:	true,
		append:		true,
		eval:		true
	};

})(jQuery);